/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.util.Map;
import org.neo4j.common.EntityType;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.AbstractResourceIterable;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextRelationship;
import org.neo4j.kernel.impl.core.AbstractNodeEntity;

public class ExecutionContextNode
extends AbstractNodeEntity {
    private final long nodeId;
    private final ExecutionContext executionContext;

    public ExecutionContextNode(long nodeId, ExecutionContext executionContext) {
        this.nodeId = nodeId;
        this.executionContext = executionContext;
    }

    public long getId() {
        return this.nodeId;
    }

    public String getElementId() {
        return this.executionContext.elementIdMapper().nodeElementId(this.nodeId);
    }

    public boolean hasProperty(String key) {
        CursorFactory cursors = this.executionContext.cursors();
        try (NodeCursor nodes = cursors.allocateNodeCursor(this.executionContext.cursorContext());){
            boolean bl;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleNode(nodes);
                    bl = this.hasProperty(key, (EntityCursor)nodes, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return bl;
        }
    }

    public Object getProperty(String key) {
        CursorFactory cursors = this.executionContext.cursors();
        try (NodeCursor nodes = cursors.allocateNodeCursor(this.executionContext.cursorContext());){
            Object object;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleNode(nodes);
                    object = this.getProperty(key, (EntityCursor)nodes, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return object;
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        CursorFactory cursors = this.executionContext.cursors();
        try (NodeCursor nodes = cursors.allocateNodeCursor(this.executionContext.cursorContext());){
            Object object;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleNode(nodes);
                    object = this.getProperty(key, defaultValue, (EntityCursor)nodes, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return object;
        }
    }

    public Iterable<String> getPropertyKeys() {
        CursorFactory cursors = this.executionContext.cursors();
        try (NodeCursor nodes = cursors.allocateNodeCursor(this.executionContext.cursorContext());){
            Iterable<String> iterable;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleNode(nodes);
                    iterable = this.getPropertyKeys((EntityCursor)nodes, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return iterable;
        }
    }

    public Map<String, Object> getProperties(String ... keys) {
        CursorFactory cursors = this.executionContext.cursors();
        try (NodeCursor nodes = cursors.allocateNodeCursor(this.executionContext.cursorContext());){
            Map<String, Object> map;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleNode(nodes);
                    map = this.getProperties((EntityCursor)nodes, properties, keys);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return map;
        }
    }

    public Map<String, Object> getAllProperties() {
        CursorFactory cursors = this.executionContext.cursors();
        try (NodeCursor nodes = cursors.allocateNodeCursor(this.executionContext.cursorContext());){
            Map<String, Object> map;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleNode(nodes);
                    map = this.getAllProperties((EntityCursor)nodes, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return map;
        }
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        int[] typeIds = ExecutionContextNode.relTypeIds(this.executionContext.tokenRead(), types);
        return new RelationshipsIterable(this.executionContext, this.getId(), direction, typeIds, (RelationshipFactory<Relationship>)((RelationshipFactory)this::relationship));
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        int[] typeIds = ExecutionContextNode.relTypeIds(this.executionContext.tokenRead(), types);
        return this.innerHasRelationships(direction, typeIds);
    }

    private boolean innerHasRelationships(Direction direction, int[] typeIds) {
        try (ResourceIterator<Relationship> iterator = ExecutionContextNode.getRelationshipSelectionIterator(this.executionContext, this.getId(), direction, typeIds, (RelationshipFactory<Relationship>)((RelationshipFactory)this::relationship));){
            boolean bl = iterator.hasNext();
            return bl;
        }
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction) {
        return new RelationshipsIterable(this.executionContext, this.getId(), direction, null, (RelationshipFactory<Relationship>)((RelationshipFactory)this::relationship));
    }

    public boolean hasRelationship(Direction direction) {
        return this.innerHasRelationships(direction, null);
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        int[] typeIds = ExecutionContextNode.relTypeIds(this.executionContext.tokenRead(), type);
        try (ResourceIterator<Relationship> relationships = ExecutionContextNode.getRelationshipSelectionIterator(this.executionContext, this.getId(), dir, typeIds, (RelationshipFactory<Relationship>)((RelationshipFactory)this::relationship));){
            Relationship relationship = this.getSingleRelationship(relationships, type, dir);
            return relationship;
        }
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        try (NodeCursor nodes = this.executionContext.cursors().allocateNodeCursor(this.executionContext.cursorContext());){
            Iterable<RelationshipType> iterable = this.getRelationshipTypes(nodes);
            return iterable;
        }
    }

    public int getDegree() {
        try (NodeCursor nodes = this.executionContext.cursors().allocateNodeCursor(this.executionContext.cursorContext());){
            int n = this.getDegree(nodes);
            return n;
        }
    }

    public int getDegree(RelationshipType type) {
        try (NodeCursor nodes = this.executionContext.cursors().allocateNodeCursor(this.executionContext.cursorContext());){
            int n = this.getDegree(type, nodes);
            return n;
        }
    }

    public int getDegree(Direction direction) {
        try (NodeCursor nodes = this.executionContext.cursors().allocateNodeCursor(this.executionContext.cursorContext());){
            int n = this.getDegree(direction, nodes);
            return n;
        }
    }

    public int getDegree(RelationshipType type, Direction direction) {
        try (NodeCursor nodes = this.executionContext.cursors().allocateNodeCursor(this.executionContext.cursorContext());){
            int n = this.getDegree(type, direction, nodes);
            return n;
        }
    }

    public boolean hasLabel(Label label) {
        try (NodeCursor nodes = this.executionContext.cursors().allocateNodeCursor(this.executionContext.cursorContext());){
            boolean bl = this.hasLabel(label, nodes);
            return bl;
        }
    }

    public Iterable<Label> getLabels() {
        try (NodeCursor nodes = this.executionContext.cursors().allocateNodeCursor(this.executionContext.cursorContext());){
            Iterable<Label> iterable = this.getLabels(nodes);
            return iterable;
        }
    }

    public void delete() {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public Object removeProperty(String key) {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public void addLabel(Label label) {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public void removeLabel(Label label) {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    private Relationship relationship(RelationshipTraversalCursor cursor) {
        return new ExecutionContextRelationship(cursor.relationshipReference(), this.executionContext);
    }

    @Override
    protected TokenRead tokenRead() {
        return this.executionContext.tokenRead();
    }

    @Override
    protected void singleNode(NodeCursor nodes) {
        this.executionContext.dataRead().singleNode(this.nodeId, nodes);
        if (!nodes.next()) {
            throw new NotFoundException((Throwable)new EntityNotFoundException(EntityType.NODE, this.getElementId()));
        }
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    private static ResourceIterator<Relationship> getRelationshipSelectionIterator(ExecutionContext executionContext, long nodeId, Direction direction, int[] typeIds, RelationshipFactory<Relationship> factory) {
        try (NodeCursor node = executionContext.cursors().allocateNodeCursor(executionContext.cursorContext());){
            executionContext.dataRead().singleNode(nodeId, node);
            if (!node.next()) {
                throw new NotFoundException(String.format("Node %d not found", nodeId));
            }
            CursorContext cursorContext = executionContext.cursorContext();
            CursorFactory cursors = executionContext.cursors();
            ResourceIterator resourceIterator = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.OUTGOING -> RelationshipSelections.outgoingIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, factory, (CursorContext)cursorContext);
                case Direction.INCOMING -> RelationshipSelections.incomingIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, factory, (CursorContext)cursorContext);
                case Direction.BOTH -> RelationshipSelections.allIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, factory, (CursorContext)cursorContext);
            };
            return resourceIterator;
        }
    }

    private static class RelationshipsIterable
    extends AbstractResourceIterable<Relationship> {
        private final ExecutionContext executionContext;
        private final long nodeId;
        private final Direction direction;
        private final int[] typeIds;
        private final RelationshipFactory<Relationship> factory;

        private RelationshipsIterable(ExecutionContext executionContext, long nodeId, Direction direction, int[] typeIds, RelationshipFactory<Relationship> factory) {
            this.executionContext = executionContext;
            this.nodeId = nodeId;
            this.direction = direction;
            this.typeIds = typeIds;
            this.factory = factory;
        }

        protected ResourceIterator<Relationship> newIterator() {
            return ExecutionContextNode.getRelationshipSelectionIterator(this.executionContext, this.nodeId, this.direction, this.typeIds, this.factory);
        }
    }
}

