/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.chunk.CommandChunk;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ChunkedTransaction
implements CommandBatchToApply {
    private CommandChunk chunk;
    private final CursorContext cursorContext;
    private final long transactionSequenceNumber;
    private final StoreCursors storeCursors;
    private final Commitment commitment;
    private final TransactionIdGenerator transactionIdGenerator;
    private boolean idGenerated;
    private LogPosition lastBatchLogPosition = LogPosition.UNSPECIFIED;
    private long transactionId = 0L;
    private CommandBatchToApply next;
    private LogPosition beforeTransactionStartPosition;

    public ChunkedTransaction(CursorContext cursorContext, long transactionSequenceNumber, StoreCursors storeCursors, Commitment commitment, TransactionIdGenerator transactionIdGenerator) {
        this.cursorContext = cursorContext;
        this.transactionSequenceNumber = transactionSequenceNumber;
        this.storeCursors = storeCursors;
        this.commitment = commitment;
        this.transactionIdGenerator = transactionIdGenerator;
    }

    public void init(CommandChunk chunk) {
        this.chunk = chunk;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        return this.chunk.accept(visitor);
    }

    public Subject subject() {
        return this.chunk.subject();
    }

    public long transactionId() {
        if (this.idGenerated) {
            return this.transactionId;
        }
        this.transactionId = this.transactionIdGenerator.nextId(this.transactionId);
        this.idGenerated = true;
        return this.transactionId;
    }

    public long chunkId() {
        return this.chunk.chunkMetadata().chunkId();
    }

    public LogPosition previousBatchLogPosition() {
        return this.chunk.chunkMetadata().previousBatchLogPosition();
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public StoreCursors storeCursors() {
        return this.storeCursors;
    }

    public CommandBatchToApply next() {
        return this.next;
    }

    public void next(CommandBatchToApply next) {
        this.next = next;
    }

    public void commit() {
        if (this.chunk.isLast()) {
            this.commitment.publishAsCommitted(this.chunk.chunkMetadata().chunkCommitTime());
        }
    }

    public LogPosition lastBatchLogPosition() {
        return this.lastBatchLogPosition;
    }

    public CommandBatch commandBatch() {
        return this.chunk;
    }

    public void batchAppended(LogPosition beforeStart, LogPosition positionAfter, int checksum) {
        if (this.chunk.isFirst()) {
            this.cursorContext.getVersionContext().initWrite(this.transactionId);
            this.beforeTransactionStartPosition = beforeStart;
        }
        this.commitment.commit(this.transactionId, this.beforeTransactionStartPosition, positionAfter, checksum, this.chunk.chunkMetadata().consensusIndex());
        this.lastBatchLogPosition = beforeStart;
    }

    public void close() {
        this.commitment.publishAsClosed();
    }

    public Iterator<StorageCommand> iterator() {
        return this.chunk.iterator();
    }

    public String toString() {
        return "ChunkedTransaction{transactionSequenceNumber=" + this.transactionSequenceNumber + ", transactionId=" + this.transactionId + "}";
    }
}

