/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public final class EntryTimespanThreshold
implements Threshold {
    private final long timeToKeepInMillis;
    private final Clock clock;
    private final TimeUnit timeUnit;
    private final Log log;
    private long lowerLimit;

    EntryTimespanThreshold(LogProvider logProvider, Clock clock, TimeUnit timeUnit, long timeToKeep) {
        this.log = logProvider.getLog(this.getClass());
        this.clock = clock;
        this.timeUnit = timeUnit;
        this.timeToKeepInMillis = timeUnit.toMillis(timeToKeep);
    }

    @Override
    public void init() {
        this.lowerLimit = this.clock.millis() - this.timeToKeepInMillis;
    }

    @Override
    public boolean reached(Path file, long version, LogFileInformation source) {
        try {
            long firstStartRecordTimestamp = source.getFirstStartRecordTimestamp(version);
            return firstStartRecordTimestamp >= 0L && firstStartRecordTimestamp < this.lowerLimit;
        }
        catch (IOException e) {
            this.log.warn("Fail to get timestamp info from transaction log file " + version, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.timeUnit.convert(this.timeToKeepInMillis, TimeUnit.MILLISECONDS) + " " + this.timeUnit.name().toLowerCase(Locale.ROOT);
    }
}

