/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.neo4j.scheduler.FailedJobRun;

public class FailedJobRunsStore {
    private final int sizeLimit;
    private final Deque<FailedJobRun> failedJobs;

    public FailedJobRunsStore(int sizeLimit) {
        this.sizeLimit = sizeLimit;
        this.failedJobs = new ArrayDeque<FailedJobRun>(sizeLimit);
    }

    public synchronized void add(FailedJobRun jobFailure) {
        if (this.failedJobs.size() + 1 == this.sizeLimit) {
            this.failedJobs.removeFirst();
        }
        this.failedJobs.add(jobFailure);
    }

    public synchronized List<FailedJobRun> getFailedJobRuns() {
        return new ArrayList<FailedJobRun>(this.failedJobs);
    }
}

