/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.TransactionCursors;

public class PrefetchedTransactionCursors
implements TransactionCursors {
    private final BlockingQueue<TransactionCursor> cursors = new LinkedBlockingDeque<TransactionCursor>(2);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final LogFile logFile;
    private final LogPosition beginning;
    private final LogEntryReader reader;
    private final boolean failOnCorruptedLogFiles;
    private final ReversedTransactionCursorMonitor monitor;
    private long currentVersion;

    public PrefetchedTransactionCursors(LogFile logFile, LogPosition beginning, LogEntryReader reader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) {
        this.logFile = logFile;
        this.beginning = beginning;
        this.reader = reader;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.monitor = monitor;
        this.currentVersion = logFile.getHighestLogVersion();
        monitor.presketchingTransactionLogs();
        this.executor.execute(this::prepare);
    }

    @Override
    public Optional<TransactionCursor> next() {
        try {
            TransactionCursor cursor = this.cursors.take();
            if (cursor == NO_MORE_CURSORS) {
                return Optional.empty();
            }
            return Optional.of(cursor);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepare() {
        try {
            while (this.currentVersion >= this.beginning.getLogVersion()) {
                LogPosition position = this.currentVersion > this.beginning.getLogVersion() ? this.logFile.extractHeader(this.currentVersion).getStartPosition() : this.beginning;
                ReadableLogChannel channel = this.logFile.getReader(position, LogVersionBridge.NO_MORE_CHANNELS);
                if (channel instanceof ReadAheadLogChannel) {
                    this.cursors.put(new ReversedSingleFileTransactionCursor((ReadAheadLogChannel)channel, this.reader, this.failOnCorruptedLogFiles, this.monitor));
                } else {
                    this.cursors.put(EagerlyReversedTransactionCursor.eagerlyReverse(new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)channel, this.reader)));
                }
                --this.currentVersion;
            }
            this.cursors.put(NO_MORE_CURSORS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
    }
}

