/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

public class FusionIndexCapability
implements IndexCapability {
    private static final Function<ValueCategory, ValueCategory> categoryOf = Function.identity();
    private final SlotSelector slotSelector;
    private final InstanceSelector<IndexCapability> instanceSelector;
    private final IndexBehaviour[] behaviours;

    FusionIndexCapability(SlotSelector slotSelector, InstanceSelector<IndexCapability> instanceSelector) {
        this.slotSelector = slotSelector;
        this.instanceSelector = instanceSelector;
        this.behaviours = FusionIndexCapability.buildBehaviours(slotSelector);
    }

    private static IndexBehaviour[] buildBehaviours(SlotSelector slotSelector) {
        IndexSlot slot = slotSelector.selectSlot(new ValueCategory[]{ValueCategory.TEXT}, categoryOf);
        if (slot != IndexSlot.LUCENE) {
            return new IndexBehaviour[]{IndexBehaviour.SLOW_CONTAINS};
        }
        return new IndexBehaviour[0];
    }

    public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
        IndexSlot slot = this.slotSelector.selectSlot(valueCategories, categoryOf);
        if (slot == null) {
            return IndexOrderCapability.NONE;
        }
        return this.instanceSelector.select(slot).orderCapability(valueCategories);
    }

    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        IndexSlot slot = this.slotSelector.selectSlot(valueCategories, categoryOf);
        if (slot == null) {
            return IndexValueCapability.PARTIAL;
        }
        return this.instanceSelector.select(slot).valueCapability(valueCategories);
    }

    public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
        Preconditions.requireNonEmpty((Object[])valueCategories);
        Preconditions.requireNoNullElements((Object[])valueCategories);
        IndexSlot slot = this.slotSelector.selectSlot(valueCategories, categoryOf);
        return slot != null && this.instanceSelector.select(slot).areValueCategoriesAccepted(valueCategories);
    }

    public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
        return queryType != IndexQuery.IndexQueryType.FULLTEXT_SEARCH && queryType != IndexQuery.IndexQueryType.TOKEN_LOOKUP;
    }

    public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
        return 1.0;
    }

    public boolean supportPartitionedScan(IndexQuery ... queries) {
        Preconditions.requireNonEmpty((Object[])queries);
        Preconditions.requireNoNullElements((Object[])queries);
        if (Arrays.stream(queries).map(IndexQuery::type).anyMatch(EnumSet.of(IndexQuery.IndexQueryType.TOKEN_LOOKUP, IndexQuery.IndexQueryType.ALL_ENTRIES, IndexQuery.IndexQueryType.EXISTS)::contains)) {
            return false;
        }
        PropertyIndexQuery[] propertyIndexQueries = (PropertyIndexQuery[])Arrays.stream(queries).map(PropertyIndexQuery.class::cast).toArray(PropertyIndexQuery[]::new);
        IndexSlot slot = this.slotSelector.selectSlot(propertyIndexQueries, PropertyIndexQuery::valueCategory);
        if (slot == null) {
            return false;
        }
        return this.instanceSelector.select(slot).supportPartitionedScan(queries);
    }

    public IndexBehaviour[] behaviours() {
        return this.behaviours;
    }
}

