/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;

public class LogHeaderWriter {
    private static final long LOG_VERSION_BITS = 56L;
    static final long LOG_VERSION_MASK = 0xFFFFFFFFFFFFFFL;

    private LogHeaderWriter() {
    }

    public static void writeLogHeader(FlushableChannel channel, LogHeader logHeader) throws IOException {
        channel.putLong(LogHeaderWriter.encodeLogVersion(logHeader.getLogVersion(), logHeader.getLogFormatVersion()));
        channel.putLong(logHeader.getLastCommittedTxId());
        StoreId storeId = logHeader.getStoreId();
        channel.putLong(storeId.getCreationTime());
        channel.putLong(storeId.getRandomId());
        channel.putLong(storeId.getStoreVersion());
        channel.putLong(storeId.getUpgradeTime());
        channel.putLong(storeId.getUpgradeTxId());
        channel.putLong(0L);
    }

    public static void writeLogHeader(StoreChannel channel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(64, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            buffer.putLong(LogHeaderWriter.encodeLogVersion(logHeader.getLogVersion(), logHeader.getLogFormatVersion()));
            buffer.putLong(logHeader.getLastCommittedTxId());
            StoreId storeId = logHeader.getStoreId();
            buffer.putLong(storeId.getCreationTime());
            buffer.putLong(storeId.getRandomId());
            buffer.putLong(storeId.getStoreVersion());
            buffer.putLong(storeId.getUpgradeTime());
            buffer.putLong(storeId.getUpgradeTxId());
            buffer.putLong(0L);
            buffer.flip();
            channel.writeAll(buffer);
        }
    }

    public static long encodeLogVersion(long logVersion, long formatVersion) {
        return logVersion & 0xFFFFFFFFFFFFFFL | formatVersion << 56;
    }
}

