/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

public class SketchingTransactionCursor
implements TransactionCursor {
    private final ReadableClosablePositionAwareChecksumChannel channel;
    private final LogEntryCursor logEntryCursor;
    private final LogPositionMarker lastGoodPositionMarker = new LogPositionMarker();

    public SketchingTransactionCursor(ReadableClosablePositionAwareChecksumChannel channel, LogEntryReader entryReader) throws IOException {
        this.channel = channel;
        channel.getCurrentPosition(this.lastGoodPositionMarker);
        this.logEntryCursor = new LogEntryCursor(entryReader, channel);
    }

    public CommittedTransactionRepresentation get() {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws IOException {
        while (this.hasEntries()) {
            LogEntry entry = this.logEntryCursor.get();
            if (this.isCheckPoint(entry)) {
                this.channel.getCurrentPosition(this.lastGoodPositionMarker);
                continue;
            }
            assert (entry instanceof LogEntryStart) : "Expected Start entry, read " + entry + " instead";
            while (this.hasEntries()) {
                entry = this.logEntryCursor.get();
                if (!this.isCommit(entry)) continue;
                this.channel.getCurrentPosition(this.lastGoodPositionMarker);
                return true;
            }
        }
        return false;
    }

    private boolean hasEntries() throws IOException {
        return this.logEntryCursor.next();
    }

    private boolean isCheckPoint(LogEntry entry) {
        return entry.getType() == 8 || entry.getType() == 7;
    }

    private boolean isCommit(LogEntry entry) {
        return entry.getType() == 5;
    }

    public void close() throws IOException {
        this.logEntryCursor.close();
    }

    @Override
    public LogPosition position() {
        return this.lastGoodPositionMarker.newPosition();
    }
}

