/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.memory.MemoryTracker;

class DefaultNodeValueIndexCursor
extends DefaultEntityValueIndexCursor<DefaultNodeValueIndexCursor>
implements NodeValueIndexCursor {
    private final DefaultNodeCursor securityNodeCursor;
    private int[] propertyIds;

    DefaultNodeValueIndexCursor(CursorPool<DefaultNodeValueIndexCursor> pool, DefaultNodeCursor securityNodeCursor, MemoryTracker memoryTracker) {
        super(pool, memoryTracker);
        this.securityNodeCursor = securityNodeCursor;
    }

    @Override
    protected boolean canAccessAllDescribedEntities(IndexDescriptor descriptor, AccessMode accessMode) {
        long[] labelIds;
        this.propertyIds = descriptor.schema().getPropertyIds();
        for (long label : labelIds = Arrays.stream(descriptor.schema().getEntityTokenIds()).mapToLong(i -> i).toArray()) {
            if (accessMode.allowsTraverseAllNodesWithLabel(label)) continue;
            return false;
        }
        for (int propId : this.propertyIds) {
            if (accessMode.disallowsReadPropertyForSomeLabel(propId)) {
                return false;
            }
            for (long label : labelIds) {
                if (accessMode.allowsReadNodeProperty(() -> Labels.from(label), propId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    void traceOnEntity(KernelReadTracer tracer, long entity) {
        tracer.onNode(entity);
    }

    @Override
    String implementationName() {
        return "NodeValueIndexCursor";
    }

    @Override
    protected boolean allowed(long reference, AccessMode accessMode) {
        this.readEntity(read -> read.singleNode(reference, this.securityNodeCursor));
        if (!this.securityNodeCursor.next()) {
            return false;
        }
        boolean allowed = true;
        long[] labels = this.securityNodeCursor.labelsIgnoringTxStateSetRemove().all();
        for (int prop : this.propertyIds) {
            allowed &= accessMode.allowsReadNodeProperty(() -> Labels.from(labels), prop);
        }
        return allowed;
    }

    public void node(NodeCursor cursor) {
        this.readEntity(read -> read.singleNode(this.entityReference(), cursor));
    }

    public long nodeReference() {
        return this.entityReference();
    }

    @Override
    protected ImmutableLongSet removed(TransactionState txState, LongSet removedFromIndex) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)removedFromIndex).toImmutable();
    }

    public void release() {
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
        }
    }
}

