/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

abstract class EntityValidationTransactionImpl
implements InternalTransaction {
    EntityValidationTransactionImpl() {
    }

    public <E extends Entity> E validateSameDB(E entity) {
        Object internalTransaction = entity instanceof NodeEntity ? ((NodeEntity)entity).getTransaction() : (entity instanceof RelationshipEntity ? ((RelationshipEntity)entity).getTransaction() : null);
        if (internalTransaction != null) {
            if (!internalTransaction.isOpen()) {
                throw new NotInTransactionException("The transaction of entity " + entity.getId() + " has been closed.");
            }
            if (internalTransaction.getDatabaseId() != this.getDatabaseId()) {
                throw new CypherExecutionException("Can not use an entity from another database. Entity id: " + entity.getId() + ", entity database: " + internalTransaction.getDatabaseName() + ", expected database: " + this.getDatabaseName() + ".");
            }
        }
        return entity;
    }
}

