/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.EntityState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class EntityStateImpl
implements EntityState {
    private final long id;
    private MutableLongObjectMap<Value> addedProperties;
    private MutableLongObjectMap<Value> changedProperties;
    private MutableLongSet removedProperties;
    final CollectionsFactory collectionsFactory;
    final MemoryTracker memoryTracker;

    EntityStateImpl(long id, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        this.id = id;
        this.collectionsFactory = Objects.requireNonNull(collectionsFactory);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
    }

    public long getId() {
        return this.id;
    }

    void clear() {
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    void changeProperty(int propertyKeyId, Value value) {
        if (this.addedProperties != null && this.addedProperties.containsKey((long)propertyKeyId)) {
            this.addedProperties.put((long)propertyKeyId, (Object)value);
            return;
        }
        if (this.changedProperties == null) {
            this.changedProperties = this.collectionsFactory.newValuesMap(this.memoryTracker);
        }
        this.changedProperties.put((long)propertyKeyId, (Object)value);
        if (this.removedProperties != null) {
            this.removedProperties.remove((long)propertyKeyId);
        }
    }

    void addProperty(int propertyKeyId, Value value) {
        if (this.removedProperties != null && this.removedProperties.remove((long)propertyKeyId)) {
            this.changeProperty(propertyKeyId, value);
            return;
        }
        if (this.addedProperties == null) {
            this.addedProperties = this.collectionsFactory.newValuesMap(this.memoryTracker);
        }
        this.addedProperties.put((long)propertyKeyId, (Object)value);
    }

    void removeProperty(int propertyKeyId) {
        if (this.addedProperties != null && this.addedProperties.remove((long)propertyKeyId) != null) {
            return;
        }
        if (this.removedProperties == null) {
            this.removedProperties = this.collectionsFactory.newLongSet(this.memoryTracker);
        }
        this.removedProperties.add((long)propertyKeyId);
        if (this.changedProperties != null) {
            this.changedProperties.remove((long)propertyKeyId);
        }
    }

    public Iterable<StorageProperty> addedProperties() {
        return EntityStateImpl.toStorageProperties(this.addedProperties);
    }

    public Iterable<StorageProperty> changedProperties() {
        return EntityStateImpl.toStorageProperties(this.changedProperties);
    }

    public IntIterable removedProperties() {
        return this.removedProperties == null ? IntSets.immutable.empty() : this.removedProperties.asLazy().collectInt(Math::toIntExact);
    }

    public Iterable<StorageProperty> addedAndChangedProperties() {
        if (this.addedProperties == null) {
            return EntityStateImpl.toStorageProperties(this.changedProperties);
        }
        if (this.changedProperties == null) {
            return EntityStateImpl.toStorageProperties(this.addedProperties);
        }
        return Iterables.concat((Iterable[])new Iterable[]{EntityStateImpl.toStorageProperties(this.addedProperties), EntityStateImpl.toStorageProperties(this.changedProperties)});
    }

    public boolean hasPropertyChanges() {
        return this.addedProperties != null || this.removedProperties != null || this.changedProperties != null;
    }

    public boolean isPropertyChangedOrRemoved(int propertyKey) {
        return this.removedProperties != null && this.removedProperties.contains((long)propertyKey) || this.changedProperties != null && this.changedProperties.containsKey((long)propertyKey);
    }

    public Value propertyValue(int propertyKey) {
        Value addedValue;
        if (this.removedProperties != null && this.removedProperties.contains((long)propertyKey)) {
            return Values.NO_VALUE;
        }
        if (this.addedProperties != null && (addedValue = (Value)this.addedProperties.get((long)propertyKey)) != null) {
            return addedValue;
        }
        if (this.changedProperties != null) {
            return (Value)this.changedProperties.get((long)propertyKey);
        }
        return null;
    }

    private static Iterable<StorageProperty> toStorageProperties(LongObjectMap<Value> propertyMap) {
        return propertyMap == null ? Collections.emptyList() : propertyMap.keyValuesView().collect((Function & Serializable)e -> new PropertyKeyValue(Math.toIntExact(e.getOne()), (Value)e.getTwo()));
    }
}

