/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.common.Subject;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

class IndexSamplingJobTracker {
    private final JobScheduler jobScheduler;
    private final Set<Long> executingJobs;
    private final Lock lock = new ReentrantLock(true);
    private final Condition allJobsFinished = this.lock.newCondition();
    private final String databaseName;
    private final AtomicBoolean stopped;

    IndexSamplingJobTracker(JobScheduler jobScheduler, String databaseName) {
        this.jobScheduler = jobScheduler;
        this.executingJobs = new HashSet<Long>();
        this.databaseName = databaseName;
        this.stopped = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobHandle scheduleSamplingJob(IndexSamplingJob samplingJob) {
        this.lock.lock();
        try {
            if (this.stopped.get()) {
                JobHandle jobHandle = JobHandle.EMPTY;
                return jobHandle;
            }
            long indexId = samplingJob.indexId();
            if (this.executingJobs.contains(indexId)) {
                JobHandle jobHandle = JobHandle.EMPTY;
                return jobHandle;
            }
            this.executingJobs.add(indexId);
            JobMonitoringParams monitoringParams = new JobMonitoringParams(Subject.SYSTEM, this.databaseName, "Sampling of index '" + samplingJob.indexName() + "'");
            JobHandle jobHandle = this.jobScheduler.schedule(Group.INDEX_SAMPLING, monitoringParams, () -> {
                try {
                    samplingJob.run(this.stopped);
                }
                finally {
                    this.samplingJobCompleted(samplingJob);
                }
            });
            return jobHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void samplingJobCompleted(IndexSamplingJob samplingJob) {
        this.lock.lock();
        try {
            this.executingJobs.remove(samplingJob.indexId());
            this.allJobsFinished.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void stopAndAwaitAllJobs() {
        this.lock.lock();
        try {
            this.stopped.set(true);
            while (!this.executingJobs.isEmpty()) {
                this.allJobsFinished.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

