/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;

public class RelationshipPropertyExistenceException
extends ConstraintValidationException {
    private final RelationTypeSchemaDescriptor schema;
    private final long relationshipId;

    public RelationshipPropertyExistenceException(RelationTypeSchemaDescriptor schema, ConstraintValidationException.Phase phase, long relationshipId, TokenNameLookup tokenNameLookup) {
        super((ConstraintDescriptor)ConstraintDescriptorFactory.existsForSchema((RelationTypeSchemaDescriptor)schema), phase, String.format("Relationship(%s)", relationshipId), tokenNameLookup);
        this.schema = schema;
        this.relationshipId = relationshipId;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Relationship(%s) with type `%s` must have the property `%s`", this.relationshipId, tokenNameLookup.relationshipTypeGetName(this.schema.getRelTypeId()), tokenNameLookup.propertyKeyGetName(this.schema.getPropertyId()));
    }
}

