/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Map;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.values.storable.Value;

public class NativeMinimalIndexAccessor
implements MinimalIndexAccessor {
    private final IndexDescriptor descriptor;
    private final IndexFiles indexFiles;
    private final DatabaseReadOnlyChecker readOnlyChecker;

    public NativeMinimalIndexAccessor(IndexDescriptor descriptor, IndexFiles indexFiles, DatabaseReadOnlyChecker readOnlyChecker) {
        this.descriptor = descriptor;
        this.indexFiles = indexFiles;
        this.readOnlyChecker = readOnlyChecker;
    }

    public void drop() {
        if (this.readOnlyChecker.isReadOnly()) {
            throw new IllegalStateException("Cannot drop read-only index.");
        }
        this.indexFiles.clear();
    }

    public Map<String, Value> indexConfig() {
        return this.descriptor.getIndexConfig().asMap();
    }
}

