/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultEntityTokenIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;

public class DefaultRelationshipTypeIndexCursor
extends DefaultEntityTokenIndexCursor<DefaultRelationshipTypeIndexCursor>
implements RelationshipTypeIndexCursor {
    private final DefaultRelationshipScanCursor relationshipSecurityCursor;

    DefaultRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool, DefaultRelationshipScanCursor relationshipSecurityCursor) {
        super(pool);
        this.relationshipSecurityCursor = relationshipSecurityCursor;
    }

    @Override
    LongSet createAddedInTxState(TransactionState txState, int token) {
        return txState.relationshipsWithTypeChanged(token).getAdded().freeze();
    }

    @Override
    LongSet createDeletedInTxState(TransactionState txState, int token) {
        return txState.addedAndRemovedRelationships().getRemoved().freeze();
    }

    @Override
    void traceScan(KernelReadTracer tracer, int token) {
        tracer.onRelationshipTypeScan(token);
    }

    @Override
    void traceNext(KernelReadTracer tracer, long entity) {
        tracer.onRelationship(entity);
    }

    @Override
    boolean allowedToSeeAllEntitiesWithToken(AccessMode accessMode, int token) {
        return accessMode.allowsTraverseRelType(token) && accessMode.allowsTraverseAllLabels();
    }

    @Override
    boolean allowedToSeeEntity(AccessMode accessMode, long entityReference, TokenSet tokens) {
        this.readEntity(read -> read.singleRelationship(entityReference, this.relationshipSecurityCursor));
        return this.relationshipSecurityCursor.next();
    }

    public void relationship(RelationshipScanCursor cursor) {
        this.readEntity(read -> read.singleRelationship(this.entityReference(), cursor));
    }

    public void sourceNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public void targetNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public int type() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the type in the relationship type index cursor.");
    }

    public long sourceNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public long targetNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public long relationshipReference() {
        return this.entityReference();
    }

    public float score() {
        return Float.NaN;
    }

    public void release() {
        if (this.relationshipSecurityCursor != null) {
            this.relationshipSecurityCursor.close();
            this.relationshipSecurityCursor.release();
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTypeIndexCursor[closed state]";
        }
        return "RelationshipTypeIndexCursor[relationship=" + this.entityReference() + "]";
    }
}

