/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.recovery.ParallelRecoveryVisitor;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryVisitor;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;

public class DefaultRecoveryService
implements RecoveryService {
    private final RecoveryStartInformationProvider recoveryStartInformationProvider;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final LogVersionRepository logVersionRepository;
    private final Log log;
    private final boolean doParallelRecovery;

    DefaultRecoveryService(StorageEngine storageEngine, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, LogFiles logFiles, RecoveryStartInformationProvider.Monitor monitor, Log log, boolean doParallelRecovery) {
        this.storageEngine = storageEngine;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.logVersionRepository = logVersionRepository;
        this.log = log;
        this.doParallelRecovery = doParallelRecovery;
        this.recoveryStartInformationProvider = new RecoveryStartInformationProvider(logFiles, monitor);
    }

    @Override
    public RecoveryStartInformation getRecoveryStartInformation() {
        return this.recoveryStartInformationProvider.get();
    }

    @Override
    public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode, PageCacheTracer cacheTracer, String tracerTag) {
        if (this.doParallelRecovery) {
            return new ParallelRecoveryVisitor(this.storageEngine, mode, cacheTracer, tracerTag);
        }
        return new RecoveryVisitor(this.storageEngine, mode, cacheTracer, tracerTag);
    }

    @Override
    public TransactionCursor getTransactions(long transactionId) throws IOException {
        return this.logicalTransactionStore.getTransactions(transactionId);
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactions(position);
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactionsInReverseOrder(position);
    }

    @Override
    public void transactionsRecovered(LogEntryCommit lastRecoveredTransaction, LogPosition lastRecoveredTransactionPosition, LogPosition positionAfterLastRecoveredTransaction, LogPosition checkpointPosition, boolean missingLogs, CursorContext cursorContext) {
        if (missingLogs) {
            ClosedTransactionMetadata lastClosedTransactionData = this.transactionIdStore.getLastClosedTransaction();
            long logVersion = lastClosedTransactionData.getLogPosition().getLogVersion();
            this.log.warn("Recovery detected that transaction logs were missing. Resetting offset of last closed transaction to point to the head of %d transaction log file.", new Object[]{logVersion});
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionData.getTransactionId(), logVersion, 64L, true, cursorContext);
            this.logVersionRepository.setCurrentLogVersion(logVersion, cursorContext);
            long checkpointLogVersion = this.logVersionRepository.getCheckpointLogVersion();
            if (checkpointLogVersion < 0L) {
                this.log.warn("Recovery detected that checkpoint log version is invalid. Resetting version to start from the beginning. Current recorded version: %d. New version: 0.", new Object[]{checkpointLogVersion});
                this.logVersionRepository.setCheckpointLogVersion(0L, cursorContext);
            }
            return;
        }
        if (lastRecoveredTransaction != null) {
            this.transactionIdStore.setLastCommittedAndClosedTransactionId(lastRecoveredTransaction.getTxId(), lastRecoveredTransaction.getChecksum(), lastRecoveredTransaction.getTimeWritten(), lastRecoveredTransactionPosition.getByteOffset(), lastRecoveredTransactionPosition.getLogVersion(), cursorContext);
        } else {
            long lastClosedTransactionId = this.transactionIdStore.getLastClosedTransactionId();
            this.log.warn("Recovery detected that transaction logs tail can't be trusted. Resetting offset of last closed transaction to point to the last recoverable log position: " + positionAfterLastRecoveredTransaction);
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionId, positionAfterLastRecoveredTransaction.getLogVersion(), positionAfterLastRecoveredTransaction.getByteOffset(), false, cursorContext);
        }
        this.logVersionRepository.setCurrentLogVersion(positionAfterLastRecoveredTransaction.getLogVersion(), cursorContext);
        this.logVersionRepository.setCheckpointLogVersion(checkpointPosition.getLogVersion(), cursorContext);
    }
}

