/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.storemigration.LegacyDatabaseLayout;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;

public class LogsUpgrader {
    private static final String UPGRADE_CHECKPOINT = "Upgrade checkpoint.";
    private final FileSystemAbstraction fs;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseLayout databaseLayout;
    private final PageCache pageCache;
    private final LegacyTransactionLogsLocator legacyLogsLocator;
    private final Config config;
    private final DependencyResolver dependencyResolver;
    private final PageCacheTracer tracer;
    private final MemoryTracker memoryTracker;
    private final DatabaseHealth databaseHealth;

    public LogsUpgrader(FileSystemAbstraction fs, StorageEngineFactory storageEngineFactory, DatabaseLayout databaseLayout, PageCache pageCache, LegacyTransactionLogsLocator legacyLogsLocator, Config config, DependencyResolver dependencyResolver, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, DatabaseHealth databaseHealth) {
        this.fs = fs;
        this.storageEngineFactory = storageEngineFactory;
        this.databaseLayout = databaseLayout;
        this.pageCache = pageCache;
        this.legacyLogsLocator = legacyLogsLocator;
        this.config = config;
        this.dependencyResolver = dependencyResolver;
        this.tracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
        this.databaseHealth = databaseHealth;
    }

    public void assertCleanlyShutDown(DatabaseLayout layout) {
        Throwable suppressibleException = null;
        LogTailInformation tail = null;
        try {
            DatabaseLayout oldDatabaseLayout = this.buildLegacyLogsLayout(layout);
            LogFiles logFiles = this.buildLogFiles(oldDatabaseLayout);
            tail = logFiles.getTailInformation();
            if (!tail.isRecoveryRequired()) {
                return;
            }
            if (tail.logsMissing()) {
                logFiles = this.buildLogFiles(layout);
                tail = logFiles.getTailInformation();
                if (!tail.isRecoveryRequired()) {
                    return;
                }
                if (tail.logsMissing() && !((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            suppressibleException = throwable;
        }
        StoreUpgrader.DatabaseNotCleanlyShutDownException exception = LogsUpgrader.upgradeException(tail);
        if (suppressibleException != null) {
            exception.addSuppressed(suppressibleException);
        }
        throw exception;
    }

    private DatabaseLayout buildLegacyLogsLayout(DatabaseLayout databaseLayout) {
        return new LegacyDatabaseLayout(databaseLayout.getNeo4jLayout(), databaseLayout.getDatabaseName(), this.legacyLogsLocator);
    }

    private LogFiles buildLogFiles(DatabaseLayout layout) {
        LogFiles logFiles;
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        try {
            logFiles = LogFilesBuilder.builder(layout, this.fs).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(this.config).withMemoryTracker(this.memoryTracker).withDatabaseHealth(this.databaseHealth).withDependencies(this.dependencyResolver).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return logFiles;
    }

    public void upgrade(DatabaseLayout layout) {
        try (MetadataProvider store = this.getMetaDataStore();){
            TransactionLogInitializer logInitializer = new TransactionLogInitializer(this.fs, store, this.storageEngineFactory, this.tracer);
            Path transactionLogsDirectory = layout.getTransactionLogsDirectory();
            Path legacyLogsDirectory = this.legacyLogsLocator.getTransactionLogsDirectory();
            boolean filesNeedsToMove = !transactionLogsDirectory.equals(legacyLogsDirectory);
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(legacyLogsDirectory, this.fs).withStorageEngineFactory(this.storageEngineFactory).build();
            Path[] legacyFiles = logFiles.logFiles();
            if (legacyFiles != null && legacyFiles.length > 0) {
                if (filesNeedsToMove) {
                    for (Path legacyFile : legacyFiles) {
                        this.fs.copyFile(legacyFile, transactionLogsDirectory.resolve(legacyFile.getFileName()), FileSystemAbstraction.EMPTY_COPY_OPTIONS);
                    }
                }
                logInitializer.initializeExistingLogFiles(layout, transactionLogsDirectory, UPGRADE_CHECKPOINT);
                if (filesNeedsToMove) {
                    for (Path legacyFile : legacyFiles) {
                        this.fs.deleteFile(legacyFile);
                    }
                }
            } else {
                logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(transactionLogsDirectory, this.fs).build();
                legacyFiles = logFiles.logFiles();
                if (legacyFiles != null && legacyFiles.length > 0) {
                    logInitializer.initializeExistingLogFiles(layout, transactionLogsDirectory, UPGRADE_CHECKPOINT);
                } else {
                    if (((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                        throw new UpgradeNotAllowedException();
                    }
                    logInitializer.initializeEmptyLogFile(layout, transactionLogsDirectory, UPGRADE_CHECKPOINT);
                }
            }
        }
        catch (Exception exception) {
            throw new StoreUpgrader.TransactionLogsRelocationException("Failure on attempt to move transaction logs into new location.", exception);
        }
    }

    private MetadataProvider getMetaDataStore() throws IOException {
        return this.storageEngineFactory.transactionMetaDataStore(this.fs, this.databaseLayout, this.config, this.pageCache, this.tracer, DatabaseReadOnlyChecker.readOnly());
    }

    private static StoreUpgrader.DatabaseNotCleanlyShutDownException upgradeException(LogTailInformation tail) {
        return tail == null ? new StoreUpgrader.DatabaseNotCleanlyShutDownException() : new StoreUpgrader.DatabaseNotCleanlyShutDownException(tail);
    }
}

