/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class StaticIndexProviderMap
extends LifecycleAdapter
implements IndexProviderMap {
    private final Map<IndexProviderDescriptor, IndexProvider> indexProvidersByDescriptor = new HashMap<IndexProviderDescriptor, IndexProvider>();
    private final Map<String, IndexProvider> indexProvidersByName = new HashMap<String, IndexProvider>();
    private final IndexProvider tokenIndexProvider;
    private final IndexProvider btreeIndexProvider;
    private final IndexProvider fusionIndexProvider;
    private final IndexProvider textIndexProvider;
    private final IndexProvider fulltextIndexProvider;
    private final IndexProvider rangeIndexProvider;
    private final IndexProvider pointIndexProvider;
    private final Config config;
    private final DependencyResolver dependencies;
    private volatile IndexProvider defaultIndexProvider;

    public StaticIndexProviderMap(TokenIndexProvider tokenIndexProvider, GenericNativeIndexProvider btreeIndexProvider, FusionIndexProvider fusionIndexProvider, TextIndexProvider textIndexProvider, FulltextIndexProvider fulltextIndexProvider, RangeIndexProvider rangeIndexProvider, PointIndexProvider pointIndexProvider, Config config, DependencyResolver dependencies) {
        this.tokenIndexProvider = tokenIndexProvider;
        this.btreeIndexProvider = btreeIndexProvider;
        this.fusionIndexProvider = fusionIndexProvider;
        this.textIndexProvider = textIndexProvider;
        this.fulltextIndexProvider = fulltextIndexProvider;
        this.rangeIndexProvider = rangeIndexProvider;
        this.pointIndexProvider = pointIndexProvider;
        this.config = config;
        this.dependencies = dependencies;
    }

    public void init() throws Exception {
        this.add(this.tokenIndexProvider);
        this.add(this.btreeIndexProvider);
        this.add(this.fusionIndexProvider);
        this.add(this.textIndexProvider);
        this.add(this.fulltextIndexProvider);
        this.add(this.rangeIndexProvider);
        this.add(this.pointIndexProvider);
        this.dependencies.resolveTypeDependencies(IndexProvider.class).forEach(this::add);
        this.defaultIndexProvider = this.selectDefaultProvider(this.config);
    }

    @Override
    public IndexProvider getDefaultProvider() {
        return this.defaultIndexProvider;
    }

    @Override
    public IndexProvider getFulltextProvider() {
        return this.fulltextIndexProvider;
    }

    @Override
    public IndexProvider getTokenIndexProvider() {
        return this.tokenIndexProvider;
    }

    @Override
    public IndexProvider getTextIndexProvider() {
        return this.textIndexProvider;
    }

    @Override
    public IndexProvider getRangeIndexProvider() {
        return this.rangeIndexProvider;
    }

    @Override
    public IndexProvider getPointIndexProvider() {
        return this.pointIndexProvider;
    }

    @Override
    public IndexProvider lookup(IndexProviderDescriptor providerDescriptor) {
        IndexProvider provider = this.indexProvidersByDescriptor.get(providerDescriptor);
        this.assertProviderFound(provider, providerDescriptor.name());
        return provider;
    }

    @Override
    public IndexProvider lookup(String providerDescriptorName) {
        IndexProvider provider = this.indexProvidersByName.get(providerDescriptorName);
        this.assertProviderFound(provider, providerDescriptorName);
        return provider;
    }

    @Override
    public void accept(Consumer<IndexProvider> visitor) {
        this.indexProvidersByDescriptor.values().forEach(visitor);
    }

    private void assertProviderFound(IndexProvider provider, String providerDescriptorName) {
        if (provider == null) {
            throw new IndexProviderNotFoundException("Tried to get index provider with name " + providerDescriptorName + " whereas available providers in this session being " + this.indexProvidersByName.keySet() + ", and default being " + this.defaultIndexProvider.getProviderDescriptor().name());
        }
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        IndexProviderDescriptor providerDescriptor = index.getIndexProvider();
        IndexProvider provider = this.lookup(providerDescriptor);
        return provider.completeConfiguration(index);
    }

    private void add(IndexProvider provider) {
        IndexProviderDescriptor providerDescriptor = Objects.requireNonNull(provider.getProviderDescriptor());
        IndexProvider existing = this.indexProvidersByDescriptor.putIfAbsent(providerDescriptor, provider);
        if (existing != null) {
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + providerDescriptor + ". First loaded " + existing + " then " + provider);
        }
        this.indexProvidersByName.putIfAbsent(providerDescriptor.name(), provider);
    }

    private IndexProvider selectDefaultProvider(Config config) {
        if (config.isExplicitlySet(GraphDatabaseSettings.default_schema_provider)) {
            String providerName = (String)config.get(GraphDatabaseSettings.default_schema_provider);
            IndexProvider configuredDefaultProvider = this.indexProvidersByName.get(providerName);
            Objects.requireNonNull(configuredDefaultProvider, () -> String.format("Configured default provider: `%s` not found. Available index providers: %s.", providerName, this.indexProvidersByName.keySet()));
            return configuredDefaultProvider;
        }
        return this.btreeIndexProvider;
    }
}

