/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.function.LongPredicate;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.RecoveryCondition;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class IndexSamplingControllerFactory {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStatisticsStore indexStatisticsStore;
    private final JobScheduler scheduler;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;
    private final PageCacheTracer cacheTracer;
    private final Config config;
    private final String databaseName;

    public IndexSamplingControllerFactory(IndexSamplingConfig samplingConfig, IndexStatisticsStore indexStatisticsStore, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LogProvider logProvider, PageCacheTracer cacheTracer, Config config, String databaseName) {
        this.samplingConfig = samplingConfig;
        this.indexStatisticsStore = indexStatisticsStore;
        this.scheduler = scheduler;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.databaseName = databaseName;
    }

    public IndexSamplingController create(IndexMapSnapshotProvider snapshotProvider) {
        OnlineIndexSamplingJobFactory jobFactory = new OnlineIndexSamplingJobFactory(this.indexStatisticsStore, this.tokenNameLookup, this.logProvider, this.cacheTracer);
        LongPredicate samplingUpdatePredicate = this.createSamplingPredicate();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.scheduler, this.databaseName);
        RecoveryCondition indexRecoveryCondition = this.createIndexRecoveryCondition(this.logProvider, this.tokenNameLookup);
        return new IndexSamplingController(this.samplingConfig, jobFactory, samplingUpdatePredicate, jobTracker, snapshotProvider, this.scheduler, indexRecoveryCondition, this.logProvider, this.config, this.databaseName);
    }

    private LongPredicate createSamplingPredicate() {
        return indexId -> {
            IndexSample indexInfo = this.indexStatisticsStore.indexSample(indexId);
            long updates = indexInfo.updates();
            long size = indexInfo.indexSize();
            long threshold = Math.round(this.samplingConfig.updateRatio() * (double)size);
            return updates > threshold;
        };
    }

    private RecoveryCondition createIndexRecoveryCondition(final LogProvider logProvider, final TokenNameLookup tokenNameLookup) {
        return new RecoveryCondition(){
            private final Log log;
            {
                this.log = logProvider.getLog(IndexSamplingController.class);
            }

            @Override
            public boolean test(IndexDescriptor descriptor) {
                boolean empty;
                IndexSample indexSample = IndexSamplingControllerFactory.this.indexStatisticsStore.indexSample(descriptor.getId());
                long samples = indexSample.sampleSize();
                long size = indexSample.indexSize();
                boolean bl = empty = samples == 0L || size == 0L;
                if (empty) {
                    this.log.debug("Recovering index sampling for index %s", new Object[]{descriptor.schema().userDescription(tokenNameLookup)});
                }
                return empty;
            }
        };
    }
}

