/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class IndexDefinitionImpl
implements IndexDefinition {
    private final InternalSchemaActions actions;
    private final IndexDescriptor indexReference;
    private final String description;
    private final Label[] labels;
    private final RelationshipType[] relTypes;
    private final String[] propertyKeys;
    private final boolean constraintIndex;

    public IndexDefinitionImpl(InternalSchemaActions actions, IndexDescriptor ref, Label[] labels, String[] propertyKeys, boolean constraintIndex) {
        actions.assertInOpenTransaction();
        this.actions = actions;
        this.indexReference = ref;
        this.description = actions.getUserDescription(ref);
        this.labels = labels;
        this.relTypes = null;
        this.propertyKeys = propertyKeys;
        this.constraintIndex = constraintIndex;
    }

    public IndexDefinitionImpl(InternalSchemaActions actions, IndexDescriptor ref, RelationshipType[] relTypes, String[] propertyKeys, boolean constraintIndex) {
        actions.assertInOpenTransaction();
        this.actions = actions;
        this.indexReference = ref;
        this.description = actions.getUserDescription(ref);
        this.labels = null;
        this.relTypes = relTypes;
        this.propertyKeys = propertyKeys;
        this.constraintIndex = constraintIndex;
    }

    public IndexDescriptor getIndexReference() {
        return this.indexReference;
    }

    public Iterable<Label> getLabels() {
        this.actions.assertInOpenTransaction();
        this.assertIsNodeIndex();
        return Arrays.asList(this.labels);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        this.actions.assertInOpenTransaction();
        this.assertIsRelationshipIndex();
        return Arrays.asList(this.relTypes);
    }

    public Iterable<String> getPropertyKeys() {
        this.actions.assertInOpenTransaction();
        return Arrays.asList(this.propertyKeys);
    }

    public IndexType getIndexType() {
        return this.indexReference.getIndexType().toPublicApi();
    }

    String[] getPropertyKeysArrayShared() {
        this.actions.assertInOpenTransaction();
        return this.propertyKeys;
    }

    Label[] getLabelArrayShared() {
        return this.labels;
    }

    RelationshipType[] getRelationshipTypesArrayShared() {
        return this.relTypes;
    }

    public void drop() {
        try {
            this.actions.dropIndexDefinitions(this);
        }
        catch (ConstraintViolationException e) {
            if (this.isConstraintIndex()) {
                throw new IllegalStateException("Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", e);
            }
            throw e;
        }
    }

    public boolean isConstraintIndex() {
        this.actions.assertInOpenTransaction();
        return this.constraintIndex;
    }

    public boolean isNodeIndex() {
        this.actions.assertInOpenTransaction();
        return this.internalIsNodeIndex();
    }

    private boolean internalIsNodeIndex() {
        return this.labels != null;
    }

    public boolean isRelationshipIndex() {
        this.actions.assertInOpenTransaction();
        return this.relTypes != null;
    }

    public boolean isMultiTokenIndex() {
        this.actions.assertInOpenTransaction();
        return this.internalIsNodeIndex() ? this.labels.length > 1 : this.relTypes.length > 1;
    }

    public boolean isCompositeIndex() {
        this.actions.assertInOpenTransaction();
        return this.propertyKeys.length > 1;
    }

    public String getName() {
        IndexDescriptor descriptor = this.indexReference == null ? IndexDescriptor.NO_INDEX : this.indexReference;
        return descriptor.getName();
    }

    public Map<IndexSetting, Object> getIndexConfiguration() {
        IndexConfig indexConfig = this.indexReference.getIndexConfig();
        return IndexSettingUtil.toIndexSettingObjectMapFromIndexConfig(indexConfig);
    }

    public int hashCode() {
        HashFunction hf = HashFunction.incrementalXXH64();
        long hash = hf.initialise(31L);
        hash = hf.updateWithArray(hash, (Object[])this.labels, label -> label.name().hashCode());
        hash = hf.updateWithArray(hash, (Object[])this.relTypes, relType -> relType.name().hashCode());
        hash = hf.updateWithArray(hash, (Object[])this.propertyKeys, String::hashCode);
        return hf.toInt(hash);
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDefinitionImpl other = (IndexDefinitionImpl)obj;
        if (this.internalIsNodeIndex()) {
            if (other.labels == null) {
                return false;
            }
            if (this.labels.length != other.labels.length) {
                return false;
            }
            for (i = 0; i < this.labels.length; ++i) {
                if (this.labels[i].name().equals(other.labels[i].name())) continue;
                return false;
            }
        }
        if (this.relTypes != null) {
            if (other.relTypes == null) {
                return false;
            }
            if (this.relTypes.length != other.relTypes.length) {
                return false;
            }
            for (i = 0; i < this.relTypes.length; ++i) {
                if (this.relTypes[i].name().equals(other.relTypes[i].name())) continue;
                return false;
            }
        }
        return Arrays.equals(this.propertyKeys, other.propertyKeys);
    }

    public String toString() {
        return "IndexDefinition[" + (this.internalIsNodeIndex() ? this.getSchemaForLabels() : this.getSchemaForRelType()) + "]" + (String)(this.description == null ? "" : " (" + this.description + ")");
    }

    private String getSchemaForLabels() {
        String entityTokenType = this.labels.length > 1 ? "labels" : "label";
        String entityTokens = ArrayUtils.isNotEmpty((Object[])this.labels) ? Arrays.stream(this.labels).map(Label::name).collect(Collectors.joining(",")) : "<any-labels>";
        String onPropertyKeys = ArrayUtils.isNotEmpty((Object[])this.propertyKeys) ? " on:" + String.join((CharSequence)",", this.propertyKeys) : "";
        return entityTokenType + ":" + entityTokens + onPropertyKeys;
    }

    private String getSchemaForRelType() {
        String entityTokenType = this.relTypes.length > 1 ? "relationship types" : "relationship type";
        String entityTokens = ArrayUtils.isNotEmpty((Object[])this.relTypes) ? Arrays.stream(this.relTypes).map(RelationshipType::name).collect(Collectors.joining(",")) : "<any-types>";
        String onPropertyKeys = ArrayUtils.isNotEmpty((Object[])this.propertyKeys) ? " on:" + String.join((CharSequence)",", this.propertyKeys) : "";
        return entityTokenType + ":" + entityTokens + onPropertyKeys;
    }

    static String labelNameList(Iterable<Label> labels, String prefix, String postfix) {
        return Iterables.stream(labels).map(Label::name).collect(Collectors.joining(", ", prefix, postfix));
    }

    private void assertIsNodeIndex() {
        if (!this.isNodeIndex()) {
            throw new IllegalStateException("This is not a node index.");
        }
    }

    private void assertIsRelationshipIndex() {
        if (!this.isRelationshipIndex()) {
            throw new IllegalStateException("This is not a relationship index.");
        }
    }
}

