/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.List;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.storemigration.IndexConfigMigrator;
import org.neo4j.kernel.impl.storemigration.IndexProviderMigrator;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.LogsUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;

public class DatabaseMigrator {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogService logService;
    private final DependencyResolver dependencyResolver;
    private final PageCache pageCache;
    private final JobScheduler jobScheduler;
    private final DatabaseLayout databaseLayout;
    private final LegacyTransactionLogsLocator legacyLogsLocator;
    private final StorageEngineFactory storageEngineFactory;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;
    private final DatabaseHealth databaseHealth;

    public DatabaseMigrator(FileSystemAbstraction fs, Config config, LogService logService, DependencyResolver dependencyResolver, PageCache pageCache, JobScheduler jobScheduler, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, DatabaseHealth databaseHealth) {
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.dependencyResolver = dependencyResolver;
        this.pageCache = pageCache;
        this.jobScheduler = jobScheduler;
        this.databaseLayout = databaseLayout;
        this.legacyLogsLocator = new LegacyTransactionLogsLocator(config, databaseLayout);
        this.storageEngineFactory = storageEngineFactory;
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
        this.databaseHealth = databaseHealth;
    }

    public void migrate(boolean forceUpgrade) throws IOException {
        StoreVersionCheck versionCheck = this.storageEngineFactory.versionCheck(this.fs, this.databaseLayout, this.config, this.pageCache, this.logService, this.pageCacheTracer);
        LogsUpgrader logsUpgrader = new LogsUpgrader(this.fs, this.storageEngineFactory, this.databaseLayout, this.pageCache, this.legacyLogsLocator, this.config, this.dependencyResolver, this.pageCacheTracer, this.memoryTracker, this.databaseHealth);
        Log userLog = this.logService.getUserLog(DatabaseMigrator.class);
        VisibleMigrationProgressMonitor progress = new VisibleMigrationProgressMonitor(userLog);
        LogProvider logProvider = this.logService.getInternalLogProvider();
        StoreUpgrader storeUpgrader = new StoreUpgrader(this.storageEngineFactory, versionCheck, progress, this.config, this.fs, logProvider, logsUpgrader, this.pageCacheTracer);
        List storeParticipants = this.storageEngineFactory.migrationParticipants(this.fs, this.config, this.pageCache, this.jobScheduler, this.logService, this.pageCacheTracer, this.memoryTracker);
        storeParticipants.forEach(storeUpgrader::addParticipant);
        IndexProviderMap indexProviderMap = (IndexProviderMap)this.dependencyResolver.resolveDependency(IndexProviderMap.class);
        IndexConfigMigrator indexConfigMigrator = new IndexConfigMigrator(this.fs, this.config, this.pageCache, this.logService, this.storageEngineFactory, indexProviderMap, this.logService.getUserLog(IndexConfigMigrator.class), this.pageCacheTracer, this.memoryTracker);
        storeUpgrader.addParticipant((StoreMigrationParticipant)indexConfigMigrator);
        IndexProviderMigrator indexProviderMigrator = new IndexProviderMigrator(this.fs, this.config, this.pageCache, this.logService, this.storageEngineFactory, this.pageCacheTracer, this.memoryTracker);
        storeUpgrader.addParticipant((StoreMigrationParticipant)indexProviderMigrator);
        indexProviderMap.accept(provider -> storeUpgrader.addParticipant(provider.storeMigrationParticipant(this.fs, this.pageCache, this.storageEngineFactory)));
        try {
            storeUpgrader.migrateIfNeeded(this.databaseLayout, forceUpgrade);
        }
        catch (Exception e) {
            userLog.error("Error upgrading database. Database left intact and will likely not be able to start: " + e.toString());
            throw e;
        }
    }
}

