/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import inet.ipaddr.IPAddressString;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;

public class WebURLAccessRule
implements URLAccessRule {
    public static final String LOAD_CSV_USER_AGENT_PREFIX = "NeoLoadCSV_";
    private static final int REDIRECT_LIMIT = 10;

    public static String userAgent() {
        Runtime.Version version = Runtime.version();
        String agent = System.getProperty("http.agent");
        if (agent == null) {
            return "Java/" + version;
        }
        return agent + " Java/" + version;
    }

    public static void checkNotBlocked(URL url, List<IPAddressString> blockedIpRanges) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(url.getHost());
        for (IPAddressString blockedIpRange : blockedIpRanges) {
            if (!blockedIpRange.contains(new IPAddressString(inetAddress.getHostAddress()))) continue;
            throw new URLAccessValidationError("access to " + inetAddress + " is blocked via the configuration property " + GraphDatabaseInternalSettings.cypher_ip_blocklist.name());
        }
    }

    public static HttpURLConnection checkUrlIncludingHops(URL url, List<IPAddressString> blockedIpRanges) throws Exception {
        HttpURLConnection con;
        boolean isRedirect;
        URL result = url;
        int redirectLimit = 10;
        do {
            URL newUrl;
            WebURLAccessRule.checkNotBlocked(result, blockedIpRanges);
            con = (HttpURLConnection)result.openConnection();
            con.setRequestProperty("User-Agent", String.format("%s%s", LOAD_CSV_USER_AGENT_PREFIX, WebURLAccessRule.userAgent()));
            con.setInstanceFollowRedirects(false);
            con.connect();
            con.getInputStream();
            isRedirect = WebURLAccessRule.isRedirect(con.getResponseCode());
            if (!isRedirect) continue;
            if (redirectLimit-- == 0) {
                con.disconnect();
                throw new IOException("Redirect limit exceeded");
            }
            String location = con.getHeaderField("Location");
            if (location == null) {
                con.disconnect();
                throw new IOException("URL responded with a redirect but the location header was null");
            }
            try {
                newUrl = new URL(location);
                if (!newUrl.getProtocol().equalsIgnoreCase(result.getProtocol())) {
                    return con;
                }
            }
            catch (MalformedURLException e) {
                newUrl = new URL(con.getURL(), location);
            }
            result = newUrl;
        } while (isRedirect);
        return con;
    }

    private static boolean isRedirect(int responseCode) {
        return responseCode >= 300 && responseCode <= 307 && responseCode != 306 && responseCode != 304;
    }

    public URL validate(Configuration config, URL url) throws URLAccessValidationError {
        List blockedIpRanges = (List)config.get(GraphDatabaseInternalSettings.cypher_ip_blocklist);
        String host = url.getHost();
        if (!blockedIpRanges.isEmpty() && host != null && !host.isEmpty()) {
            try {
                HttpURLConnection con = WebURLAccessRule.checkUrlIncludingHops(url, blockedIpRanges);
                con.disconnect();
            }
            catch (Exception e) {
                throw new URLAccessValidationError("Unable to verify access to " + host + ". Cause: " + e.getMessage());
            }
        }
        return url;
    }
}

