/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import java.util.Map;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.PointIndexAccessor;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.PointLayout;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.ValueCategory;

public class PointIndexProvider
extends NativeIndexProvider<PointKey, PointLayout> {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("point", "1.0");
    public static final IndexCapability CAPABILITY = new PointIndexCapability();
    static final IndexUpdateIgnoreStrategy UPDATE_IGNORE_STRATEGY = values -> values[0].valueGroup().category() != ValueCategory.GEOMETRY;
    private final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private final boolean archiveFailedIndex;
    private final Config config;

    public PointIndexProvider(DatabaseIndexContext databaseIndexContext, IndexDirectoryStructure.Factory directoryStructureFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config) {
        super(databaseIndexContext, DESCRIPTOR, directoryStructureFactory, recoveryCleanupWorkCollector);
        this.configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        this.configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration(config);
        this.archiveFailedIndex = (Boolean)config.get(GraphDatabaseInternalSettings.archive_failed_index);
        this.config = config;
    }

    @Override
    PointLayout layout(IndexDescriptor descriptor, Path storeFile) {
        IndexConfig indexConfig = descriptor.getIndexConfig();
        Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = SpatialIndexConfig.extractSpatialConfig(indexConfig);
        IndexSpecificSpaceFillingCurveSettings spatialSettings = new IndexSpecificSpaceFillingCurveSettings(settings);
        return new PointLayout(spatialSettings);
    }

    @Override
    protected IndexPopulator newIndexPopulator(IndexFiles indexFiles, PointLayout layout, IndexDescriptor descriptor, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
        return new PointBlockBasedIndexPopulator(this.databaseIndexContext, indexFiles, layout, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration, this.archiveFailedIndex, bufferFactory, this.config, memoryTracker);
    }

    @Override
    protected IndexAccessor newIndexAccessor(IndexFiles indexFiles, PointLayout layout, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return new PointIndexAccessor(this.databaseIndexContext, indexFiles, layout, this.recoveryCleanupWorkCollector, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration);
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        IndexConfig indexConfig = index.getIndexConfig();
        if ((index = index.withIndexConfig(indexConfig = this.completeSpatialConfiguration(indexConfig))).getCapability().equals(IndexCapability.NO_CAPABILITY)) {
            index = index.withIndexCapability(CAPABILITY);
        }
        return index;
    }

    private IndexConfig completeSpatialConfiguration(IndexConfig indexConfig) {
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            SpaceFillingCurveSettings spaceFillingCurveSettings = this.configuredSettings.forCRS(crs);
            indexConfig = SpatialIndexConfig.addSpatialConfig(indexConfig, crs, spaceFillingCurveSettings);
        }
        return indexConfig;
    }

    public void validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        if (indexType != IndexType.POINT) {
            String providerName = this.getProviderDescriptor().name();
            throw new IllegalArgumentException("The '" + providerName + "' index provider does not support " + indexType + " indexes: " + prototype);
        }
        if (!prototype.schema().isLabelSchemaDescriptor() && !prototype.schema().isRelationshipTypeSchemaDescriptor()) {
            throw new IllegalArgumentException("The " + prototype.schema() + " index schema is not a point index schema, which it is required to be for the '" + this.getProviderDescriptor().name() + "' index provider to be able to create an index.");
        }
        if (!prototype.getIndexProvider().equals((Object)DESCRIPTOR)) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support " + prototype.getIndexProvider() + " indexes: " + prototype);
        }
        if (prototype.isUnique()) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support uniqueness indexes: " + prototype);
        }
        if (prototype.schema().getPropertyIds().length != 1) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support composite indexes: " + prototype);
        }
        IndexConfig indexConfig = prototype.getIndexConfig();
        indexConfig = this.completeSpatialConfiguration(indexConfig);
        try {
            SpatialIndexConfig.validateSpatialConfig(indexConfig);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid spatial index settings.", e);
        }
    }

    public IndexType getIndexType() {
        return IndexType.POINT;
    }

    private static class PointIndexCapability
    implements IndexCapability {
        private PointIndexCapability() {
        }

        public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
            return IndexOrderCapability.NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.YES;
        }

        public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
            Preconditions.requireNonEmpty((Object[])valueCategories);
            Preconditions.requireNoNullElements((Object[])valueCategories);
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.GEOMETRY;
        }

        public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
            if (queryType == IndexQuery.IndexQueryType.ALL_ENTRIES) {
                return true;
            }
            if (!this.areValueCategoriesAccepted(valueCategory)) {
                return false;
            }
            switch (queryType) {
                case EXACT: 
                case RANGE: {
                    return true;
                }
            }
            return false;
        }

        public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
            return 1.0;
        }

        public boolean supportPartitionedScan(IndexQuery ... queries) {
            Preconditions.requireNonEmpty((Object[])queries);
            Preconditions.requireNoNullElements((Object[])queries);
            return false;
        }
    }
}

