/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.database.transaction;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.OptionalLong;
import java.util.concurrent.locks.Lock;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.api.database.transaction.LogChannel;
import org.neo4j.kernel.api.database.transaction.TransactionLogChannels;
import org.neo4j.kernel.api.database.transaction.TransactionLogService;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.util.Preconditions;

public class TransactionLogServiceImpl
implements TransactionLogService {
    private final LogFiles logFiles;
    private final LogicalTransactionStore transactionStore;
    private final MetadataProvider metadataProvider;
    private final Lock pruneLock;
    private final LogFile logFile;
    private final DatabaseAvailabilityGuard availabilityGuard;

    public TransactionLogServiceImpl(MetadataProvider metadataProvider, LogFiles logFiles, LogicalTransactionStore transactionStore, Lock pruneLock, DatabaseAvailabilityGuard availabilityGuard) {
        this.metadataProvider = metadataProvider;
        this.logFiles = logFiles;
        this.transactionStore = transactionStore;
        this.pruneLock = pruneLock;
        this.logFile = logFiles.getLogFile();
        this.availabilityGuard = availabilityGuard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionLogChannels logFilesChannels(long startingTxId) throws IOException {
        Preconditions.requirePositive((long)startingTxId);
        LogPosition minimalLogPosition = this.getLogPosition(startingTxId);
        this.pruneLock.lock();
        try {
            long minimalVersion = minimalLogPosition.getLogVersion();
            ClosedTransactionMetadata lastClosedTransaction = this.metadataProvider.getLastClosedTransaction();
            ArrayList<LogChannel> channels = this.collectChannels(startingTxId, minimalLogPosition, minimalVersion, lastClosedTransaction);
            TransactionLogChannels transactionLogChannels = new TransactionLogChannels(channels);
            return transactionLogChannels;
        }
        finally {
            this.pruneLock.unlock();
        }
    }

    @Override
    public LogPosition append(ByteBuffer byteBuffer, OptionalLong transactionId) throws IOException {
        Preconditions.checkState((!this.availabilityGuard.isAvailable() ? 1 : 0) != 0, (String)"Database should not be available.");
        return this.logFile.append(byteBuffer, transactionId);
    }

    @Override
    public void restore(LogPosition position) throws IOException {
        Preconditions.checkState((!this.availabilityGuard.isAvailable() ? 1 : 0) != 0, (String)"Database should not be available.");
        this.logFile.truncate(position);
    }

    private ArrayList<LogChannel> collectChannels(long startingTxId, LogPosition minimalLogPosition, long minimalVersion, ClosedTransactionMetadata lastClosedTransaction) throws IOException {
        LogPosition highestLogPosition = lastClosedTransaction.getLogPosition();
        long highestTxId = lastClosedTransaction.getTransactionId();
        long highestLogVersion = highestLogPosition.getLogVersion();
        int exposedChannels = (int)(highestLogVersion - minimalVersion + 1L);
        ArrayList<LogChannel> channels = new ArrayList<LogChannel>(exposedChannels);
        MutableLongObjectMap internalChannels = LongObjectMaps.mutable.ofInitialCapacity(exposedChannels);
        for (long version = minimalVersion; version <= highestLogVersion; ++version) {
            long startPositionTxId = this.logFileTransactionId(startingTxId, minimalVersion, version);
            ReadOnlyStoreChannel readOnlyStoreChannel = new ReadOnlyStoreChannel(this.logFile, version);
            if (version == minimalVersion) {
                readOnlyStoreChannel.position(minimalLogPosition.getByteOffset());
            }
            internalChannels.put(version, (Object)readOnlyStoreChannel);
            long endOffset = version < highestLogVersion ? readOnlyStoreChannel.size() : highestLogPosition.getByteOffset();
            long lastTxId = version < highestLogVersion ? this.getHeaderLastCommittedTx(version + 1L) : highestTxId;
            channels.add(new LogChannel(startPositionTxId, (StoreChannel)readOnlyStoreChannel, endOffset, lastTxId));
        }
        this.logFile.registerExternalReaders((LongObjectMap<StoreChannel>)internalChannels);
        return channels;
    }

    private long logFileTransactionId(long startingTxId, long minimalVersion, long version) throws IOException {
        return version == minimalVersion ? startingTxId : this.getHeaderLastCommittedTx(version) + 1L;
    }

    private long getHeaderLastCommittedTx(long version) throws IOException {
        return this.logFile.extractHeader(version).getLastCommittedTxId();
    }

    private LogPosition getLogPosition(long startingTxId) throws IOException {
        LogPosition logPosition;
        block8: {
            TransactionCursor transactionCursor = this.transactionStore.getTransactions(startingTxId);
            try {
                logPosition = transactionCursor.position();
                if (transactionCursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (transactionCursor != null) {
                        try {
                            transactionCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchTransactionException e) {
                    throw new IllegalArgumentException("Transaction id " + startingTxId + " not found in transaction logs.", e);
                }
            }
            transactionCursor.close();
        }
        return logPosition;
    }

    private static class ReadOnlyStoreChannel
    extends DelegatingStoreChannel<StoreChannel> {
        private final LogFile logFile;
        private final long version;

        ReadOnlyStoreChannel(LogFile logFile, long version) throws IOException {
            super((StoreChannel)logFile.openForVersion(version));
            this.logFile = logFile;
            this.version = version;
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public int write(ByteBuffer src) throws IOException {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public void writeAll(ByteBuffer src) throws IOException {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public void writeAll(ByteBuffer src, long position) throws IOException {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public StoreChannel truncate(long size) throws IOException {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public long write(ByteBuffer[] srcs) throws IOException {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public void close() throws IOException {
            this.logFile.unregisterExternalReader(this.version, (StoreChannel)this);
            super.close();
        }
    }
}

