/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.RecoveryCondition;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

public class IndexSamplingController {
    private final IndexSamplingJobFactory jobFactory;
    private final LongPredicate samplingUpdatePredicate;
    private final IndexSamplingJobTracker jobTracker;
    private final IndexMapSnapshotProvider indexMapSnapshotProvider;
    private final JobScheduler scheduler;
    private final RecoveryCondition indexRecoveryCondition;
    private final boolean backgroundSampling;
    private final Lock samplingLock = new ReentrantLock();
    private final Log log;
    private final boolean logRecoverIndexSamples;
    private final boolean asyncRecoverIndexSamples;
    private final boolean asyncRecoverIndexSamplesWait;
    private final String databaseName;
    private JobHandle backgroundSamplingHandle;

    IndexSamplingController(IndexSamplingConfig samplingConfig, IndexSamplingJobFactory jobFactory, LongPredicate samplingUpdatePredicate, IndexSamplingJobTracker jobTracker, IndexMapSnapshotProvider indexMapSnapshotProvider, JobScheduler scheduler, RecoveryCondition indexRecoveryCondition, LogProvider logProvider, Config config, String databaseName) {
        this.backgroundSampling = samplingConfig.backgroundSampling();
        this.jobFactory = jobFactory;
        this.indexMapSnapshotProvider = indexMapSnapshotProvider;
        this.samplingUpdatePredicate = samplingUpdatePredicate;
        this.jobTracker = jobTracker;
        this.scheduler = scheduler;
        this.indexRecoveryCondition = indexRecoveryCondition;
        this.log = logProvider.getLog(this.getClass());
        this.logRecoverIndexSamples = (Boolean)config.get(GraphDatabaseInternalSettings.log_recover_index_samples);
        this.asyncRecoverIndexSamples = (Boolean)config.get(GraphDatabaseInternalSettings.async_recover_index_samples);
        this.asyncRecoverIndexSamplesWait = (Boolean)config.get(GraphDatabaseInternalSettings.async_recover_index_samples_wait);
        this.databaseName = databaseName;
    }

    public void sampleIndexes(IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        LongList indexesToSample = this.indexesToSample(mode, indexMap);
        this.scheduleSampling((LongIterable)indexesToSample, mode, indexMap);
    }

    public void sampleIndex(long indexId, IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        if (this.shouldSampleIndex(mode, indexId)) {
            this.scheduleSampling((LongIterable)LongLists.immutable.of(indexId), mode, indexMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverIndexSamples() {
        this.samplingLock.lock();
        try {
            IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
            LongIterator indexIds = indexMap.indexIds();
            MutableList asyncSamplingJobs = Lists.mutable.of();
            while (indexIds.hasNext()) {
                long indexId = indexIds.next();
                IndexDescriptor descriptor = indexMap.getIndexProxy(indexId).getDescriptor();
                if (this.indexRecoveryCondition.test(descriptor) && descriptor.getIndexType() != IndexType.LOOKUP) {
                    if (this.logRecoverIndexSamples) {
                        this.log.info("Index requires sampling, id=%d, name=%s.", new Object[]{indexId, descriptor.getName()});
                    }
                    if (this.asyncRecoverIndexSamples) {
                        asyncSamplingJobs.add(this.sampleIndexOnTracker(indexMap, indexId));
                        continue;
                    }
                    this.sampleIndexOnCurrentThread(indexMap, indexId);
                    continue;
                }
                if (!this.logRecoverIndexSamples) continue;
                this.log.info("Index does not require sampling, id=%d, name=%s.", new Object[]{indexId, descriptor.getName()});
            }
            if (this.asyncRecoverIndexSamplesWait) {
                IndexSamplingController.waitForAsyncIndexSamples((List<IndexSamplingJobHandle>)asyncSamplingJobs);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private static void waitForAsyncIndexSamples(List<IndexSamplingJobHandle> asyncSamplingJobs) {
        for (IndexSamplingJobHandle asyncSamplingJob : asyncSamplingJobs) {
            try {
                asyncSamplingJob.waitTermination();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                String indexName = asyncSamplingJob.descriptor.getName();
                throw new RuntimeException("Failed to asynchronously sample index during recovery, index '" + indexName + "'.", e);
            }
        }
    }

    private void scheduleSampling(LongIterable indexesToSample, IndexSamplingMode mode, IndexMap indexMap) {
        List<IndexSamplingJobHandle> allJobs = this.scheduleAllSampling(indexesToSample, indexMap);
        long millisToWait = mode.millisToWaitForCompletion();
        if (millisToWait != 0L) {
            IndexSamplingController.waitForAsyncIndexSamples(allJobs, millisToWait);
        }
    }

    private static void waitForAsyncIndexSamples(List<IndexSamplingJobHandle> allJobs, long millisToWait) {
        long start = System.nanoTime();
        long deadline = start + TimeUnit.MILLISECONDS.toNanos(millisToWait);
        for (IndexSamplingJobHandle job : allJobs) {
            try {
                job.waitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(String.format("Could not finish index sampling within the given time limit, %d milliseconds.", millisToWait), e);
            }
            catch (InterruptedException | ExecutionException e) {
                IndexDescriptor index = job.descriptor;
                throw new RuntimeException(String.format("Index sampling of index '%s' failed, cause: %s", index.getName(), e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexSamplingJobHandle> scheduleAllSampling(LongIterable indexesToSample, IndexMap indexMap) {
        this.samplingLock.lock();
        try {
            MutableList allJobs = Lists.mutable.of();
            indexesToSample.forEach((LongProcedure & Serializable)l -> allJobs.add((Object)this.sampleIndexOnTracker(indexMap, l)));
            MutableList mutableList = allJobs;
            return mutableList;
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private IndexSamplingJobHandle sampleIndexOnTracker(IndexMap indexMap, long indexId) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, indexId);
        IndexDescriptor descriptor = indexMap.getIndexProxy(indexId).getDescriptor();
        if (job != null) {
            return new IndexSamplingJobHandle(this.jobTracker.scheduleSamplingJob(job), descriptor);
        }
        return new IndexSamplingJobHandle(JobHandle.EMPTY, descriptor);
    }

    private void sampleIndexOnCurrentThread(IndexMap indexMap, long indexId) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, indexId);
        if (job != null) {
            job.run();
        }
    }

    private IndexSamplingJob createSamplingJob(IndexMap indexMap, long indexId) {
        IndexProxy proxy = indexMap.getIndexProxy(indexId);
        if (proxy == null || proxy.getState() != InternalIndexState.ONLINE || proxy.getDescriptor().getIndexType() == IndexType.LOOKUP) {
            return null;
        }
        return this.jobFactory.create(indexId, proxy);
    }

    public void start() {
        if (this.backgroundSampling) {
            Runnable samplingRunner = () -> this.sampleIndexes(IndexSamplingMode.backgroundRebuildUpdated());
            JobMonitoringParams monitoringParams = JobMonitoringParams.systemJob((String)this.databaseName, (String)"Background rebuilding of updated indexes");
            this.backgroundSamplingHandle = this.scheduler.scheduleRecurring(Group.INDEX_SAMPLING, monitoringParams, samplingRunner, 10L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.backgroundSamplingHandle != null) {
            this.backgroundSamplingHandle.cancel();
        }
        this.jobTracker.stopAndAwaitAllJobs();
    }

    private LongList indexesToSample(IndexSamplingMode mode, IndexMap indexMap) {
        MutableLongList indexesToSample = LongLists.mutable.of();
        LongIterator allIndexes = indexMap.indexIds();
        while (allIndexes.hasNext()) {
            long indexId = allIndexes.next();
            if (!this.shouldSampleIndex(mode, indexId)) continue;
            indexesToSample.add(indexId);
        }
        return indexesToSample;
    }

    private boolean shouldSampleIndex(IndexSamplingMode mode, long indexId) {
        return !mode.sampleOnlyIfUpdated() || this.samplingUpdatePredicate.test(indexId);
    }

    private static class IndexSamplingJobHandle {
        private final JobHandle jobHandle;
        private final IndexDescriptor descriptor;

        IndexSamplingJobHandle(JobHandle jobHandle, IndexDescriptor descriptor) {
            this.jobHandle = jobHandle;
            this.descriptor = descriptor;
        }

        public void waitTermination() throws ExecutionException, InterruptedException {
            this.jobHandle.waitTermination();
        }

        public void waitTermination(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.jobHandle.waitTermination(timeout, unit);
        }
    }
}

