/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.values.storable.ValueCategory;

public interface SlotSelector {
    public static final SlotSelector nullInstance = new NullInstance();

    public void validateSatisfied(InstanceSelector<IndexProvider> var1);

    public <V> IndexSlot selectSlot(V[] var1, Function<V, ValueCategory> var2);

    public static void validateSelectorInstances(InstanceSelector<IndexProvider> instances, IndexSlot ... aliveIndex) {
        for (IndexSlot indexSlot : IndexSlot.values()) {
            boolean actual;
            boolean expected = ArrayUtils.contains((Object[])aliveIndex, (Object)((Object)indexSlot));
            boolean bl = actual = instances.select(indexSlot) != IndexProvider.EMPTY;
            if (expected == actual) continue;
            throw new IllegalArgumentException(String.format("Only indexes expected to be separated from IndexProvider.EMPTY are %s but was %s", Arrays.toString((Object[])aliveIndex), instances));
        }
    }

    public static class NullInstance
    implements SlotSelector {
        @Override
        public void validateSatisfied(InstanceSelector<IndexProvider> instances) {
        }

        @Override
        public <V> IndexSlot selectSlot(V[] values, Function<V, ValueCategory> categoryOf) {
            throw new UnsupportedOperationException("NullInstance cannot select a slot for you. Please use the real deal.");
        }
    }
}

