/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;

class PointLayout
extends IndexLayout<PointKey> {
    private final IndexSpecificSpaceFillingCurveSettings spatialSettings;

    PointLayout(IndexSpecificSpaceFillingCurveSettings spatialSettings) {
        super(false, Layout.namedIdentifier((String)"PL", (int)1), 0, 1);
        this.spatialSettings = spatialSettings;
    }

    public PointKey newKey() {
        return new PointKey(this.spatialSettings);
    }

    public PointKey copyKey(PointKey key, PointKey into) {
        into.copyFrom(key);
        return into;
    }

    public int keySize(PointKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, PointKey key) {
        key.writeToCursor(cursor);
    }

    public void readKey(PageCursor cursor, PointKey into, int keySize) {
        into.readFromCursor(cursor, keySize);
    }

    public void initializeAsLowest(PointKey key) {
        key.initValueAsLowest(-1, null);
    }

    public void initializeAsHighest(PointKey key) {
        key.initValueAsHighest(-1, null);
    }

    public void minimalSplitter(PointKey left, PointKey right, PointKey into) {
        into.copyFrom(right);
        if (left.compareValueTo(right) != 0) {
            into.setEntityId(-1L);
        }
    }

    IndexSpecificSpaceFillingCurveSettings getSpaceFillingCurveSettings() {
        return this.spatialSettings;
    }
}

