/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;

class TokenIndexProxyStrategy
implements IndexProxyStrategy {
    private volatile IndexDescriptor descriptor;
    private final TokenNameLookup tokenNameLookup;
    private final boolean allowToChangeDescriptor;

    TokenIndexProxyStrategy(IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean allowToChangeDescriptor) {
        this.descriptor = descriptor;
        this.tokenNameLookup = tokenNameLookup;
        this.allowToChangeDescriptor = allowToChangeDescriptor;
    }

    @Override
    public IndexDescriptor getIndexDescriptor() {
        return this.descriptor;
    }

    @Override
    public void removeStatisticsForIndex() {
    }

    @Override
    public void incrementUpdateStatisticsForIndex(long delta) {
    }

    @Override
    public void replaceStatisticsForIndex(IndexSample sample) {
    }

    @Override
    public void changeIndexDescriptor(IndexDescriptor descriptor) {
        if (!this.allowToChangeDescriptor) {
            throw new UnsupportedOperationException("Changing descriptor on this token index proxy strategy is not allowed");
        }
        this.descriptor = descriptor;
    }

    @Override
    public String getIndexUserDescription() {
        return this.descriptor.userDescription(this.tokenNameLookup);
    }
}

