/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;

public abstract class KnownSystemComponentVersion {
    public static final int UNKNOWN_VERSION = -1;
    private final Label versionLabel = Label.label((String)"Version");
    private final ComponentVersion componentVersion;
    protected final String componentVersionProperty;
    public final int version;
    public final String description;
    protected final AbstractSecurityLog securityLog;

    protected KnownSystemComponentVersion(ComponentVersion componentVersion, AbstractSecurityLog securityLog) {
        this.componentVersion = componentVersion;
        this.componentVersionProperty = componentVersion.getComponentName();
        this.version = componentVersion.getVersion();
        this.description = componentVersion.getDescription();
        this.securityLog = securityLog;
    }

    public boolean isCurrent() {
        return this.componentVersion.isCurrent();
    }

    public boolean migrationSupported() {
        return this.componentVersion.migrationSupported();
    }

    public boolean runtimeSupported() {
        return this.componentVersion.runtimeSupported();
    }

    protected Integer getVersion(Transaction tx) {
        return SystemGraphComponent.getVersionNumber(tx, this.componentVersionProperty);
    }

    public boolean detected(Transaction tx) {
        Integer version = this.getVersion(tx);
        return version != null && version == this.version;
    }

    public UnsupportedOperationException unsupported() {
        String message = String.format("System graph version %d for component '%s' in '%s' is not supported", this.version, this.componentVersionProperty, this.description);
        this.securityLog.error(message);
        return new UnsupportedOperationException(message);
    }

    public SystemGraphComponent.Status getStatus() {
        if (this.version == -1) {
            return SystemGraphComponent.Status.UNINITIALIZED;
        }
        if (this.isCurrent()) {
            return SystemGraphComponent.Status.CURRENT;
        }
        if (this.migrationSupported()) {
            return this.runtimeSupported() ? SystemGraphComponent.Status.REQUIRES_UPGRADE : SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE;
        }
        return SystemGraphComponent.Status.UNSUPPORTED;
    }

    protected static boolean nodesWithLabelExist(Transaction tx, Label label) {
        try (ResourceIterator nodes = tx.findNodes(label);){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    public void setVersionProperty(Transaction tx, int newVersion) {
        Node versionNode = this.findOrCreateVersionNode(tx);
        Object oldVersion = versionNode.getProperty(this.componentVersionProperty, null);
        if (oldVersion != null) {
            this.securityLog.info(String.format("Upgrading '%s' version property from %s to %d", this.componentVersionProperty, oldVersion, newVersion));
        } else {
            this.securityLog.info(String.format("Setting version for '%s' to %d", this.componentVersionProperty, newVersion));
        }
        versionNode.setProperty(this.componentVersionProperty, (Object)newVersion);
    }

    private Node findOrCreateVersionNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(this.versionLabel);){
            if (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                if (nodes.hasNext()) {
                    throw new IllegalStateException("More than one Version node exists");
                }
                Node node2 = node;
                return node2;
            }
        }
        return tx.createNode(new Label[]{this.versionLabel});
    }
}

