/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;

public class NodeStoreScan
extends PropertyAwareEntityStoreScan<StorageNodeCursor> {
    private static final String TRACER_TAG = "NodeStoreScan_getNodeCount";

    public NodeStoreScan(Config config, StorageReader storageReader, LockService locks, TokenScanConsumer labelScanConsumer, PropertyScanConsumer propertyScanConsumer, int[] labelIds, IntPredicate propertyKeyIdFilter, boolean parallelWrite, JobScheduler scheduler, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        super(config, storageReader, NodeStoreScan.getNodeCount(storageReader, cacheTracer), labelIds, propertyKeyIdFilter, propertyScanConsumer, labelScanConsumer, id -> locks.acquireNodeLock(id, LockType.SHARED), new NodeCursorBehaviour(storageReader), parallelWrite, scheduler, cacheTracer, memoryTracker);
    }

    private static long getNodeCount(StorageReader storageReader, PageCacheTracer cacheTracer) {
        try (CursorContext cursorContext = new CursorContext(cacheTracer.createPageCursorTracer(TRACER_TAG));){
            long l = storageReader.nodesGetCount(cursorContext);
            return l;
        }
    }
}

