/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class IndexedStoreScan
implements StoreScan {
    private final Locks locks;
    private final Config config;
    private final StoreScan delegate;
    private final IndexDescriptor index;

    public IndexedStoreScan(Locks locks, IndexDescriptor index, Config config, StoreScan delegate) {
        this.locks = locks;
        this.config = config;
        this.delegate = delegate;
        this.index = index;
    }

    @Override
    public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
        try (Locks.Client client = this.locks.newClient();){
            client.initialize(LeaseService.NoLeaseClient.INSTANCE, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config);
            client.acquireShared(LockTracer.NONE, this.index.schema().keyType(), this.index.schema().lockingKeys());
            this.delegate.run(externalUpdatesCheck);
        }
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public PopulationProgress getProgress() {
        return this.delegate.getProgress();
    }

    @Override
    public void setPhaseTracker(PhaseTracker phaseTracker) {
        this.delegate.setPhaseTracker(phaseTracker);
    }
}

