/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.annotations.service.Service;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.service.NamedService;

@Service
@IgnoreApiCheck
public abstract class ExtensionFactory<DEPENDENCIES>
implements NamedService {
    private final ExtensionType extensionType;
    private final String name;

    protected ExtensionFactory(String name) {
        this(ExtensionType.GLOBAL, name);
    }

    protected ExtensionFactory(ExtensionType extensionType, String name) {
        this.extensionType = extensionType;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract Lifecycle newInstance(ExtensionContext var1, DEPENDENCIES var2);

    public String toString() {
        return String.format("Extension:%s[%s]", this.getClass().getSimpleName(), this.name);
    }

    ExtensionType getExtensionType() {
        return this.extensionType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionFactory that = (ExtensionFactory)o;
        return this.name.equals(that.name);
    }
}

