/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Factory;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseKernelModule;
import org.neo4j.kernel.database.DatabaseMemoryTrackers;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.DatabaseTransactionLogModule;
import org.neo4j.kernel.database.DatabaseUpgradeTransactionHandler;
import org.neo4j.kernel.database.DefaultForceOperation;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.UpgradeLocker;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.ExternalIdReuseConditionProvider;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.transaction.monitor.KernelTransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitorScheduler;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.FacadeKernelTransactionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.store.stats.DatabaseEntityCounters;
import org.neo4j.kernel.impl.storemigration.DatabaseMigrator;
import org.neo4j.kernel.impl.storemigration.DatabaseMigratorFactory;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointerLifecycle;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.AbstractLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.log.reverse.ReverseTransactionCursorLoggingMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.state.DatabaseFileListing;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.internal.locker.LockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.kernel.recovery.LoggingLogTailScannerMonitor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.lock.LockService;
import org.neo4j.lock.ReentrantLockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.DatabaseLogProvider;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.PrefixedLog;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.resources.CpuClock;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;

public class Database
extends LifecycleAdapter {
    private static final String STORE_ID_VALIDATOR_TAG = "storeIdValidator";
    private final Monitors parentMonitors;
    private final DependencyResolver globalDependencies;
    private final PageCache globalPageCache;
    private final Log msgLog;
    private final DatabaseLogService databaseLogService;
    private final DatabaseLogProvider internalLogProvider;
    private final DatabaseLogProvider userLogProvider;
    private final TokenHolders tokenHolders;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final IdGeneratorFactory idGeneratorFactory;
    private final JobScheduler scheduler;
    private final LockService lockService;
    private final FileSystemAbstraction fs;
    private final DatabaseTransactionStats transactionStats;
    private final CommitProcessFactory commitProcessFactory;
    private final ConstraintSemantics constraintSemantics;
    private final GlobalProcedures globalProcedures;
    private final IOControllerService ioControllerService;
    private final SystemNanoClock clock;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final Locks locks;
    private final DatabaseEventListeners eventListeners;
    private final DatabaseTracers tracers;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final LeaseService leaseService;
    private final ExternalIdReuseConditionProvider externalIdReuseConditionProvider;
    private Dependencies databaseDependencies;
    private LifeSupport life;
    private IndexProviderMap indexProviderMap;
    private DatabaseHealth databaseHealth;
    private final DatabaseAvailabilityGuard databaseAvailabilityGuard;
    private final DatabaseConfig databaseConfig;
    private final NamedDatabaseId namedDatabaseId;
    private final DatabaseLayout databaseLayout;
    private final DatabaseReadOnlyChecker readOnlyDatabaseChecker;
    private final IdController idController;
    private final DbmsInfo dbmsInfo;
    private final VersionContextSupplier versionContextSupplier;
    private final StorageEngineFactory storageEngineFactory;
    private StorageEngine storageEngine;
    private QueryExecutionEngine executionEngine;
    private DatabaseKernelModule kernelModule;
    private final Iterable<ExtensionFactory<?>> extensionFactories;
    private final Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    private final Factory<DatabaseHealth> databaseHealthFactory;
    private final QueryEngineProvider engineProvider;
    private volatile boolean initialized;
    private volatile boolean started;
    private Monitors databaseMonitors;
    private DatabasePageCache databasePageCache;
    private CheckpointerLifecycle checkpointerLifecycle;
    private ScopedMemoryPool otherDatabasePool;
    private final GraphDatabaseFacade databaseFacade;
    private final FileLockerService fileLockerService;
    private final KernelTransactionFactory kernelTransactionFactory;
    private final DatabaseStartupController startupController;
    private final GlobalMemoryGroupTracker transactionsMemoryPool;
    private final GlobalMemoryGroupTracker otherMemoryPool;
    private MemoryTracker otherDatabaseMemoryTracker;
    private RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private DatabaseAvailability databaseAvailability;
    private DatabaseTransactionEventListeners databaseTransactionEventListeners;
    private IOController ioController;

    public Database(DatabaseCreationContext context) {
        this.namedDatabaseId = context.getNamedDatabaseId();
        this.databaseLayout = context.getDatabaseLayout();
        this.databaseConfig = context.getDatabaseConfig();
        this.idGeneratorFactory = context.getIdGeneratorFactory();
        this.globalDependencies = context.getGlobalDependencies();
        this.scheduler = context.getScheduler();
        this.transactionsMemoryPool = context.getTransactionsMemoryPool();
        this.otherMemoryPool = context.getOtherMemoryPool();
        this.databaseLogService = context.getDatabaseLogService();
        this.storeCopyCheckPointMutex = context.getStoreCopyCheckPointMutex();
        this.internalLogProvider = context.getDatabaseLogService().getInternalLogProvider();
        this.userLogProvider = context.getDatabaseLogService().getUserLogProvider();
        this.tokenHolders = context.getTokenHolders();
        this.locks = context.getLocks();
        this.transactionEventListeners = context.getTransactionEventListeners();
        this.fs = context.getFs();
        this.transactionStats = context.getTransactionStats();
        this.databaseHealthFactory = context.getDatabaseHealthFactory();
        this.constraintSemantics = context.getConstraintSemantics();
        this.parentMonitors = context.getMonitors();
        this.globalProcedures = context.getGlobalProcedures();
        this.ioControllerService = context.getIoControllerService();
        this.clock = context.getClock();
        this.eventListeners = context.getDatabaseEventListeners();
        this.accessCapabilityFactory = context.getAccessCapabilityFactory();
        this.idController = context.getIdController();
        this.dbmsInfo = context.getDbmsInfo();
        this.versionContextSupplier = context.getVersionContextSupplier();
        this.extensionFactories = context.getExtensionFactories();
        this.watcherServiceFactory = context.getWatcherServiceFactory();
        this.engineProvider = context.getEngineProvider();
        this.msgLog = this.internalLogProvider.getLog(((Object)((Object)this)).getClass());
        this.lockService = new ReentrantLockService();
        this.commitProcessFactory = context.getCommitProcessFactory();
        this.globalPageCache = context.getPageCache();
        this.collectionsFactorySupplier = context.getCollectionsFactorySupplier();
        this.storageEngineFactory = context.getStorageEngineFactory();
        long availabilityGuardTimeout = ((Duration)this.databaseConfig.get(GraphDatabaseInternalSettings.transaction_start_timeout)).toMillis();
        this.databaseAvailabilityGuard = context.getDatabaseAvailabilityGuardFactory().apply(availabilityGuardTimeout);
        this.databaseFacade = new GraphDatabaseFacade(this, this.databaseConfig, this.dbmsInfo, this.databaseAvailabilityGuard);
        this.kernelTransactionFactory = new FacadeKernelTransactionFactory(this.databaseConfig, this.databaseFacade);
        this.tracers = new DatabaseTracers(context.getTracers());
        this.fileLockerService = context.getFileLockerService();
        this.leaseService = context.getLeaseService();
        this.startupController = context.getStartupController();
        this.readOnlyDatabaseChecker = new DatabaseReadOnlyChecker.Default(context.getDbmsReadOnlyChecker(), this.namedDatabaseId.name());
        this.externalIdReuseConditionProvider = context.externalIdReuseConditionProvider();
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        try {
            this.databaseDependencies = new Dependencies(this.globalDependencies);
            this.ioController = this.ioControllerService.createIOController(this.databaseConfig, this.clock);
            this.databasePageCache = new DatabasePageCache(this.globalPageCache, this.ioController);
            this.databaseMonitors = new Monitors(this.parentMonitors, (LogProvider)this.internalLogProvider);
            this.life = new LifeSupport();
            this.life.add((Lifecycle)new LockerLifecycleAdapter(this.fileLockerService.createDatabaseLocker(this.fs, this.databaseLayout)));
            this.life.add((Lifecycle)this.databaseConfig);
            this.databaseHealth = (DatabaseHealth)this.databaseHealthFactory.newInstance();
            this.databaseAvailability = new DatabaseAvailability(this.databaseAvailabilityGuard, this.transactionStats, (Clock)this.clock, this.getAwaitActiveTransactionDeadlineMillis());
            this.databaseDependencies.satisfyDependency((Object)this);
            this.databaseDependencies.satisfyDependency((Object)this.ioController);
            this.databaseDependencies.satisfyDependency((Object)this.readOnlyDatabaseChecker);
            this.databaseDependencies.satisfyDependency((Object)this.databaseLayout);
            this.databaseDependencies.satisfyDependency((Object)this.startupController);
            this.databaseDependencies.satisfyDependency((Object)this.databaseConfig);
            this.databaseDependencies.satisfyDependency((Object)this.databaseMonitors);
            this.databaseDependencies.satisfyDependency((Object)this.databaseLogService);
            this.databaseDependencies.satisfyDependency((Object)this.databasePageCache);
            this.databaseDependencies.satisfyDependency((Object)this.tokenHolders);
            this.databaseDependencies.satisfyDependency((Object)this.databaseFacade);
            this.databaseDependencies.satisfyDependency((Object)this.kernelTransactionFactory);
            this.databaseDependencies.satisfyDependency((Object)this.databaseHealth);
            this.databaseDependencies.satisfyDependency((Object)this.storeCopyCheckPointMutex);
            this.databaseDependencies.satisfyDependency((Object)this.transactionStats);
            this.databaseDependencies.satisfyDependency((Object)this.locks);
            this.databaseDependencies.satisfyDependency((Object)this.databaseAvailabilityGuard);
            this.databaseDependencies.satisfyDependency((Object)this.databaseAvailability);
            this.databaseDependencies.satisfyDependency((Object)this.idGeneratorFactory);
            this.databaseDependencies.satisfyDependency((Object)this.idController);
            this.databaseDependencies.satisfyDependency((Object)this.lockService);
            this.databaseDependencies.satisfyDependency((Object)this.versionContextSupplier);
            this.databaseDependencies.satisfyDependency((Object)this.tracers.getDatabaseTracer());
            this.databaseDependencies.satisfyDependency((Object)this.tracers.getPageCacheTracer());
            this.databaseDependencies.satisfyDependency((Object)this.storageEngineFactory);
            this.recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
            this.databaseDependencies.satisfyDependency((Object)this.recoveryCleanupWorkCollector);
            this.life.add((Lifecycle)new PageCacheLifecycle(this.databasePageCache));
            this.life.add((Lifecycle)this.initializeExtensions(this.databaseDependencies));
            DatabaseLayoutWatcher watcherService = this.watcherServiceFactory.apply(this.databaseLayout);
            this.life.add((Lifecycle)watcherService);
            this.databaseDependencies.satisfyDependency((Object)watcherService);
            this.otherDatabasePool = this.otherMemoryPool.newDatabasePool(this.namedDatabaseId.name(), 0L, null);
            this.life.add(Database.onShutdown(() -> this.otherDatabasePool.close()));
            this.otherDatabaseMemoryTracker = this.otherDatabasePool.getPoolMemoryTracker();
            this.databaseDependencies.satisfyDependency((Object)new DatabaseMemoryTrackers(this.otherDatabaseMemoryTracker));
            this.eventListeners.databaseCreate(this.namedDatabaseId);
            this.initialized = true;
        }
        catch (Throwable e) {
            this.handleStartupFailure(e);
        }
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.init();
        try {
            this.upgradeStore(this.databaseConfig, this.databasePageCache, this.otherDatabaseMemoryTracker);
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
            LogFiles logFiles = this.getLogFiles((LogEntryReader)logEntryReader);
            this.databaseMonitors.addMonitorListener((Object)new LoggingLogFileMonitor(this.msgLog), new String[0]);
            this.databaseMonitors.addMonitorListener((Object)new LoggingLogTailScannerMonitor(this.internalLogProvider.getLog(AbstractLogTailScanner.class)), new String[0]);
            this.databaseMonitors.addMonitorListener((Object)new ReverseTransactionCursorLoggingMonitor(this.internalLogProvider.getLog(ReversedSingleFileTransactionCursor.class)), new String[0]);
            PageCacheTracer pageCacheTracer = this.tracers.getPageCacheTracer();
            boolean storageExists = this.storageEngineFactory.storageExists(this.fs, this.databaseLayout, (PageCache)this.databasePageCache);
            this.validateStoreAndTxLogs(logFiles, pageCacheTracer, storageExists);
            Recovery.performRecovery(this.fs, this.databasePageCache, this.tracers, this.databaseConfig, this.databaseLayout, this.storageEngineFactory, false, (LogProvider)this.internalLogProvider, this.databaseMonitors, this.extensionFactories, Optional.of(logFiles), new RecoveryStartupChecker(this.startupController, this.namedDatabaseId), this.otherDatabaseMemoryTracker, (Clock)this.clock);
            DatabaseSchemaState databaseSchemaState = new DatabaseSchemaState((LogProvider)this.internalLogProvider);
            this.idController.initialize(() -> this.kernelModule.kernelTransactions().get());
            this.storageEngine = this.storageEngineFactory.instantiate(this.fs, this.databaseLayout, (Config)this.databaseConfig, (PageCache)this.databasePageCache, this.tokenHolders, (SchemaState)databaseSchemaState, (ConstraintRuleAccessor)this.constraintSemantics, (IndexConfigCompleter)this.indexProviderMap, this.lockService, this.idGeneratorFactory, this.idController, this.databaseHealth, (LogProvider)this.internalLogProvider, this.recoveryCleanupWorkCollector, pageCacheTracer, !storageExists, this.readOnlyDatabaseChecker, this.otherDatabaseMemoryTracker);
            MetadataProvider metadataProvider = this.storageEngine.metadataProvider();
            this.databaseDependencies.satisfyDependency((Object)metadataProvider);
            logFiles = this.getLogFiles((LogEntryReader)logEntryReader);
            this.life.add((Lifecycle)this.storageEngine);
            this.life.add(this.storageEngine.schemaAndTokensLifecycle());
            this.life.add((Lifecycle)logFiles);
            FullScanStoreView fullScanStoreView = new FullScanStoreView(this.lockService, () -> ((StorageEngine)this.storageEngine).newReader(), this.databaseConfig, this.scheduler);
            IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory(this.databaseConfig, () -> ((StorageEngine)this.storageEngine).newReader(), this.locks, fullScanStoreView, this.lockService, (LogProvider)this.internalLogProvider);
            IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(this.databasePageCache, this.databaseLayout, this.recoveryCleanupWorkCollector, this.readOnlyDatabaseChecker, pageCacheTracer);
            IndexingService indexingService = this.buildIndexingService(this.storageEngine, databaseSchemaState, indexStoreViewFactory, indexStatisticsStore, pageCacheTracer, this.otherDatabaseMemoryTracker);
            this.databaseDependencies.satisfyDependency((Object)this.storageEngine.countsAccessor());
            this.versionContextSupplier.init(() -> ((MetadataProvider)metadataProvider).getLastClosedTransactionId());
            DefaultForceOperation forceOperation = new DefaultForceOperation(indexingService, this.storageEngine);
            DatabaseTransactionLogModule transactionLogModule = this.buildTransactionLogs(logFiles, this.databaseConfig, (LogProvider)this.internalLogProvider, this.scheduler, forceOperation, (LogEntryReader)logEntryReader, metadataProvider, this.databaseMonitors, this.databaseDependencies);
            this.databaseTransactionEventListeners = new DatabaseTransactionEventListeners(this.databaseFacade, this.transactionEventListeners, this.namedDatabaseId);
            this.life.add((Lifecycle)this.databaseTransactionEventListeners);
            DatabaseKernelModule kernelModule = this.buildKernel(logFiles, transactionLogModule.transactionAppender(), indexingService, databaseSchemaState, this.storageEngine, (TransactionIdStore)metadataProvider, (KernelVersionRepository)metadataProvider, this.databaseAvailabilityGuard, this.clock, indexStatisticsStore, this.leaseService);
            kernelModule.satisfyDependencies(this.databaseDependencies);
            this.kernelModule = kernelModule;
            this.databaseDependencies.satisfyDependency((Object)databaseSchemaState);
            this.databaseDependencies.satisfyDependency((Object)logEntryReader);
            this.databaseDependencies.satisfyDependency((Object)this.storageEngine);
            this.databaseDependencies.satisfyDependency((Object)indexingService);
            this.databaseDependencies.satisfyDependency((Object)indexStoreViewFactory);
            this.databaseDependencies.satisfyDependency((Object)indexStatisticsStore);
            this.databaseDependencies.satisfyDependency((Object)this.indexProviderMap);
            this.databaseDependencies.satisfyDependency((Object)forceOperation);
            this.databaseDependencies.satisfyDependency((Object)new DatabaseEntityCounters(this.idGeneratorFactory, (CountsAccessor)this.databaseDependencies.resolveDependency(CountsAccessor.class)));
            QueryEngineProvider.SPI providerSpi = QueryEngineProvider.spi((LogProvider)this.internalLogProvider, this.databaseMonitors, this.scheduler, this.life, this.getKernel(), this.databaseConfig);
            this.executionEngine = QueryEngineProvider.initialize(this.databaseDependencies, this.databaseFacade, this.engineProvider, this.isSystem(), providerSpi);
            this.checkpointerLifecycle = new CheckpointerLifecycle(transactionLogModule.checkPointer(), (Health)this.databaseHealth, this.ioController);
            this.life.add((Lifecycle)this.databaseHealth);
            this.life.add((Lifecycle)this.databaseAvailabilityGuard);
            this.life.add((Lifecycle)this.databaseAvailability);
            this.life.setLast((Lifecycle)this.checkpointerLifecycle);
            ((DbmsDiagnosticsManager)this.databaseDependencies.resolveDependency(DbmsDiagnosticsManager.class)).dumpDatabaseDiagnostics(this);
            this.life.start();
            this.registerUpgradeListener();
            this.eventListeners.databaseStart(this.namedDatabaseId);
            this.databaseHealth.healed();
            this.started = true;
            this.postStartupInit(storageExists);
        }
        catch (Throwable e) {
            this.handleStartupFailure(e);
        }
    }

    private void postStartupInit(boolean storageExists) throws KernelException {
        if (!storageExists) {
            if (((Boolean)this.databaseConfig.get(GraphDatabaseInternalSettings.skip_default_indexes_on_creation)).booleanValue()) {
                return;
            }
            try (KernelTransaction tx = this.kernelModule.kernelAPI().beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                this.createLookupIndex(tx, EntityType.NODE);
                this.createLookupIndex(tx, EntityType.RELATIONSHIP);
                tx.commit();
            }
        }
    }

    private void createLookupIndex(KernelTransaction tx, EntityType entityType) throws KernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptor.forAnyEntityTokens((EntityType)entityType);
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)descriptor).withIndexType(IndexType.LOOKUP).withIndexProvider(this.indexProviderMap.getTokenIndexProvider().getProviderDescriptor());
        prototype = prototype.withName(SchemaRule.generateName((SchemaDescriptorSupplier)prototype, (String[])new String[0], (String[])new String[0]));
        tx.schemaWrite().indexCreate(prototype);
    }

    private LogFiles getLogFiles(LogEntryReader logEntryReader) throws IOException {
        return LogFilesBuilder.builder(this.databaseLayout, this.fs).withLogEntryReader(logEntryReader).withConfig(this.databaseConfig).withDependencies((DependencyResolver)this.databaseDependencies).withLogProvider((LogProvider)this.internalLogProvider).withDatabaseTracers(this.tracers).withMemoryTracker(this.otherDatabaseMemoryTracker).withMonitors(this.databaseMonitors).withClock((Clock)this.clock).withCommandReaderFactory(this.storageEngineFactory.commandReaderFactory()).build();
    }

    private void registerUpgradeListener() {
        DatabaseUpgradeTransactionHandler handler = new DatabaseUpgradeTransactionHandler(this.storageEngine, (DbmsRuntimeRepository)this.globalDependencies.resolveDependency(DbmsRuntimeRepository.class), (KernelVersionRepository)this.storageEngine.metadataProvider(), this.databaseTransactionEventListeners, UpgradeLocker.DEFAULT, (LogProvider)this.internalLogProvider);
        handler.registerUpgradeListener(commands -> {
            PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(commands);
            long time = this.clock.millis();
            transactionRepresentation.setHeader(ArrayUtils.EMPTY_BYTE_ARRAY, time, this.storageEngine.metadataProvider().getLastClosedTransactionId(), time, this.leaseService.newClient().leaseId(), AuthSubject.AUTH_DISABLED);
            TransactionToApply toApply = new TransactionToApply(transactionRepresentation, CursorContext.NULL);
            TransactionCommitProcess commitProcess = (TransactionCommitProcess)this.databaseDependencies.resolveDependency(TransactionCommitProcess.class);
            commitProcess.commit(toApply, CommitEvent.NULL, TransactionApplicationMode.INTERNAL);
        });
    }

    private void validateStoreAndTxLogs(LogFiles logFiles, PageCacheTracer pageCacheTracer, boolean storageExists) throws IOException {
        if (storageExists) {
            this.checkStoreId(logFiles, pageCacheTracer);
        } else {
            this.validateLogsAndStoreAbsence(logFiles);
        }
    }

    private void validateLogsAndStoreAbsence(LogFiles logFiles) throws IOException {
        if (ArrayUtils.isNotEmpty((Object[])logFiles.logFiles())) {
            throw new RuntimeException(String.format("Fail to start '%s' since transaction logs were found, while database files are missing.", this.namedDatabaseId));
        }
    }

    private void handleStartupFailure(Throwable e) {
        this.databaseAvailabilityGuard.startupFailure(e);
        this.msgLog.warn("Exception occurred while starting the database. Trying to stop already started components.", e);
        try {
            this.safeCleanup();
        }
        catch (Exception closeException) {
            this.msgLog.error("Couldn't close database after startup failure", (Throwable)closeException);
        }
        throw new RuntimeException(e);
    }

    private void checkStoreId(LogFiles logFiles, PageCacheTracer pageCacheTracer) throws IOException {
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(STORE_ID_VALIDATOR_TAG));){
            Recovery.validateStoreId(logFiles, this.storageEngineFactory.storeId(this.fs, this.databaseLayout, (PageCache)this.databasePageCache, cursorContext), this.databaseConfig);
        }
    }

    private LifeSupport initializeExtensions(Dependencies dependencies) {
        LifeSupport extensionsLife = new LifeSupport();
        extensionsLife.add((Lifecycle)new DatabaseExtensions(new DatabaseExtensionContext(this.databaseLayout, this.dbmsInfo, (DependencySatisfier)dependencies), this.extensionFactories, dependencies, ExtensionFailureStrategies.fail()));
        this.indexProviderMap = (IndexProviderMap)extensionsLife.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)dependencies, this.databaseConfig));
        dependencies.satisfyDependency((Object)this.indexProviderMap);
        extensionsLife.init();
        return extensionsLife;
    }

    private void upgradeStore(DatabaseConfig databaseConfig, DatabasePageCache databasePageCache, MemoryTracker memoryTracker) throws IOException {
        this.createDatabaseMigrator(databaseConfig, databasePageCache, memoryTracker).migrate(false);
    }

    private DatabaseMigrator createDatabaseMigrator(DatabaseConfig databaseConfig, DatabasePageCache databasePageCache, MemoryTracker memoryTracker) {
        DatabaseMigratorFactory factory = new DatabaseMigratorFactory(this.fs, databaseConfig, (LogService)this.databaseLogService, databasePageCache, this.scheduler, this.namedDatabaseId, this.tracers.getPageCacheTracer(), memoryTracker, this.databaseHealth);
        return factory.createDatabaseMigrator(this.databaseLayout, this.storageEngineFactory, (DependencyResolver)this.databaseDependencies);
    }

    private IndexingService buildIndexingService(StorageEngine storageEngine, DatabaseSchemaState databaseSchemaState, IndexStoreViewFactory indexStoreViewFactory, IndexStatisticsStore indexStatisticsStore, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        return (IndexingService)this.life.add((Lifecycle)Database.buildIndexingService(storageEngine, databaseSchemaState, indexStoreViewFactory, indexStatisticsStore, this.databaseConfig, this.scheduler, this.indexProviderMap, (TokenNameLookup)this.tokenHolders, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)this.databaseMonitors.newMonitor(IndexingService.Monitor.class, new String[0]), pageCacheTracer, memoryTracker, this.namedDatabaseId.name(), this.readOnlyDatabaseChecker));
    }

    public static IndexingService buildIndexingService(StorageEngine storageEngine, DatabaseSchemaState databaseSchemaState, IndexStoreViewFactory indexStoreViewFactory, IndexStatisticsStore indexStatisticsStore, Config config, JobScheduler jobScheduler, IndexProviderMap indexProviderMap, TokenNameLookup tokenNameLookup, LogProvider internalLogProvider, LogProvider userLogProvider, IndexingService.Monitor indexingServiceMonitor, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, String databaseName, DatabaseReadOnlyChecker readOnlyChecker) {
        IndexingService indexingService = IndexingServiceFactory.createIndexingService(config, jobScheduler, indexProviderMap, indexStoreViewFactory, tokenNameLookup, Database.initialSchemaRulesLoader(storageEngine), internalLogProvider, userLogProvider, indexingServiceMonitor, databaseSchemaState, indexStatisticsStore, pageCacheTracer, memoryTracker, databaseName, readOnlyChecker);
        storageEngine.addIndexUpdateListener((IndexUpdateListener)indexingService);
        return indexingService;
    }

    public boolean isSystem() {
        return this.namedDatabaseId.isSystemDatabase();
    }

    private DatabaseTransactionLogModule buildTransactionLogs(LogFiles logFiles, Config config, LogProvider logProvider, JobScheduler scheduler, CheckPointerImpl.ForceOperation forceOperation, LogEntryReader logEntryReader, MetadataProvider metadataProvider, Monitors monitors, Dependencies databaseDependencies) {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        LogPruningImpl logPruning = new LogPruningImpl(this.fs, logFiles, logProvider, new LogPruneStrategyFactory(), this.clock, config);
        LogRotation logRotation = FileLogRotation.transactionLogRotation(logFiles, (Clock)this.clock, (Health)this.databaseHealth, (LogRotationMonitor)monitors.newMonitor(LogRotationMonitor.class, new String[0]));
        BatchingTransactionAppender appender = (BatchingTransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(logFiles, logRotation, transactionMetadataCache, (TransactionIdStore)metadataProvider, (Health)this.databaseHealth));
        PhysicalLogicalTransactionStore logicalTransactionStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, logEntryReader, monitors, true);
        CheckPointThreshold threshold = CheckPointThreshold.createThreshold(config, this.clock, logPruning, logProvider);
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        CheckPointerImpl checkPointer = new CheckPointerImpl(metadataProvider, threshold, forceOperation, logPruning, checkpointAppender, (Health)this.databaseHealth, logProvider, this.tracers, this.ioController, this.storeCopyCheckPointMutex, this.versionContextSupplier, (Clock)this.clock);
        long recurringPeriod = threshold.checkFrequencyMillis();
        CheckPointScheduler checkPointScheduler = new CheckPointScheduler(checkPointer, this.ioController, scheduler, recurringPeriod, (Health)this.databaseHealth, this.namedDatabaseId.name());
        this.life.add((Lifecycle)checkPointer);
        this.life.add((Lifecycle)checkPointScheduler);
        databaseDependencies.satisfyDependencies(new Object[]{checkPointer, logFiles, logicalTransactionStore, logRotation, appender});
        return new DatabaseTransactionLogModule(checkPointer, appender);
    }

    private DatabaseKernelModule buildKernel(LogFiles logFiles, TransactionAppender appender, IndexingService indexingService, DatabaseSchemaState databaseSchemaState, StorageEngine storageEngine, TransactionIdStore transactionIdStore, KernelVersionRepository kernelVersionRepository, AvailabilityGuard databaseAvailabilityGuard, SystemNanoClock clock, IndexStatisticsStore indexStatisticsStore, LeaseService leaseService) {
        AtomicReference<CpuClock> cpuClockRef = this.setupCpuClockAtomicReference();
        TransactionCommitProcess transactionCommitProcess = this.commitProcessFactory.create(appender, storageEngine, this.namedDatabaseId, this.readOnlyDatabaseChecker);
        Supplier<Kernel> kernelProvider = () -> this.kernelModule.kernelAPI();
        ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, indexingService, (LogProvider)this.internalLogProvider);
        TransactionExecutionMonitor transactionExecutionMonitor = (TransactionExecutionMonitor)this.getMonitors().newMonitor(TransactionExecutionMonitor.class, new String[0]);
        KernelTransactions kernelTransactions = (KernelTransactions)this.life.add((Lifecycle)new KernelTransactions(this.databaseConfig, this.locks, constraintIndexCreator, transactionCommitProcess, this.databaseTransactionEventListeners, this.transactionStats, databaseAvailabilityGuard, storageEngine, this.globalProcedures, transactionIdStore, (DbmsRuntimeRepository)this.globalDependencies.resolveDependency(DbmsRuntimeRepository.class), kernelVersionRepository, clock, cpuClockRef, this.accessCapabilityFactory, this.versionContextSupplier, this.collectionsFactorySupplier, this.constraintSemantics, databaseSchemaState, this.tokenHolders, this.getNamedDatabaseId(), indexingService, indexStatisticsStore, this.databaseDependencies, this.tracers, leaseService, this.transactionsMemoryPool, this.readOnlyDatabaseChecker, transactionExecutionMonitor, this.externalIdReuseConditionProvider));
        this.buildTransactionMonitor(kernelTransactions, this.databaseConfig);
        KernelImpl kernel = new KernelImpl(kernelTransactions, (Health)this.databaseHealth, this.transactionStats, this.globalProcedures, this.databaseConfig, storageEngine, transactionExecutionMonitor);
        this.life.add((Lifecycle)kernel);
        DatabaseFileListing fileListing = new DatabaseFileListing(this.databaseLayout, logFiles, indexingService, storageEngine, this.idGeneratorFactory);
        this.databaseDependencies.satisfyDependency((Object)fileListing);
        return new DatabaseKernelModule(transactionCommitProcess, kernel, kernelTransactions, fileListing);
    }

    private AtomicReference<CpuClock> setupCpuClockAtomicReference() {
        AtomicReference<CpuClock> cpuClock = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);
        SettingChangeListener cpuClockUpdater = (before, after) -> {
            if (after.booleanValue()) {
                cpuClock.set(CpuClock.CPU_CLOCK);
            } else {
                cpuClock.set(CpuClock.NOT_AVAILABLE);
            }
        };
        cpuClockUpdater.accept(null, (Object)((Boolean)this.databaseConfig.get(GraphDatabaseSettings.track_query_cpu_time)));
        this.databaseConfig.addListener(GraphDatabaseSettings.track_query_cpu_time, cpuClockUpdater);
        return cpuClock;
    }

    private void buildTransactionMonitor(KernelTransactions kernelTransactions, Config config) {
        KernelTransactionMonitor kernelTransactionTimeoutMonitor = new KernelTransactionMonitor(kernelTransactions, this.clock, (LogService)this.databaseLogService);
        this.databaseDependencies.satisfyDependency((Object)kernelTransactionTimeoutMonitor);
        TransactionMonitorScheduler transactionMonitorScheduler = new TransactionMonitorScheduler(kernelTransactionTimeoutMonitor, this.scheduler, ((Duration)config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toMillis(), this.namedDatabaseId.name());
        this.life.add((Lifecycle)transactionMonitorScheduler);
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.eventListeners.databaseShutdown(this.namedDatabaseId);
        this.life.stop();
        this.awaitAllClosingTransactions();
        this.life.shutdown();
        this.started = false;
        this.initialized = false;
    }

    public synchronized void shutdown() throws Exception {
        this.safeCleanup();
        this.started = false;
        this.initialized = false;
    }

    private void safeCleanup() throws Exception {
        ThrowingAction.executeAll((ThrowingAction[])new ThrowingAction[]{() -> Database.safeLifeShutdown(this.life), () -> Database.safeStorageEngineClose(this.storageEngine), () -> Database.safePoolRelease(this.otherDatabasePool)});
    }

    public void prepareToDrop() {
        this.prepareStop(Predicates.alwaysTrue());
        this.checkpointerLifecycle.setCheckpointOnShutdown(false);
    }

    public synchronized void drop() {
        if (this.started) {
            this.prepareToDrop();
            this.stop();
        }
        this.deleteDatabaseFiles(List.of(this.databaseLayout.databaseDirectory(), this.databaseLayout.getTransactionLogsDirectory()));
        this.eventListeners.databaseDrop(this.namedDatabaseId);
    }

    private void deleteDatabaseFiles(List<Path> files) {
        try {
            for (Path fileToDelete : files) {
                FileSystemUtils.deleteFile((FileSystemAbstraction)this.fs, (Path)fileToDelete);
            }
        }
        catch (IOException e) {
            ((PrefixedLog)this.internalLogProvider.getLog(Database.class)).error(String.format("Failed to delete '%s' files.", this.namedDatabaseId), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    public synchronized void upgrade(boolean startAfterUpgrade) throws IOException {
        if (this.started) {
            this.stop();
        }
        this.init();
        DatabaseMigrator migrator = this.createDatabaseMigrator(this.databaseConfig, this.databasePageCache, this.otherDatabaseMemoryTracker);
        migrator.migrate(true);
        this.start();
        if (!startAfterUpgrade) {
            this.stop();
        }
    }

    private void awaitAllClosingTransactions() {
        this.msgLog.info("Waiting for closing transactions.");
        KernelTransactions kernelTransactions = this.kernelModule.kernelTransactions();
        kernelTransactions.terminateTransactions();
        while (kernelTransactions.haveClosingTransaction()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        this.msgLog.info("All transactions are closed.");
    }

    public Config getConfig() {
        return this.databaseConfig;
    }

    public DatabaseLogService getLogService() {
        return this.databaseLogService;
    }

    public DatabaseLogProvider getInternalLogProvider() {
        return this.internalLogProvider;
    }

    public StoreId getStoreId() {
        return this.storageEngine.getStoreId();
    }

    public DatabaseLayout getDatabaseLayout() {
        return this.databaseLayout;
    }

    public Monitors getMonitors() {
        return this.databaseMonitors;
    }

    public QueryExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public Kernel getKernel() {
        return this.kernelModule.kernelAPI();
    }

    public ResourceIterator<StoreFileMetadata> listStoreFiles(boolean includeLogs) throws IOException {
        DatabaseFileListing.StoreFileListingBuilder fileListingBuilder = this.getDatabaseFileListing().builder();
        fileListingBuilder.excludeIdFiles();
        if (!includeLogs) {
            fileListingBuilder.excludeLogFiles();
        }
        return fileListingBuilder.build();
    }

    public DatabaseFileListing getDatabaseFileListing() {
        return this.kernelModule.fileListing();
    }

    public Dependencies getDependencyResolver() {
        return this.databaseDependencies;
    }

    public JobScheduler getScheduler() {
        return this.scheduler;
    }

    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
        return this.storeCopyCheckPointMutex;
    }

    public NamedDatabaseId getNamedDatabaseId() {
        return this.namedDatabaseId;
    }

    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    public DatabaseAvailabilityGuard getDatabaseAvailabilityGuard() {
        return this.databaseAvailabilityGuard;
    }

    public GraphDatabaseFacade getDatabaseFacade() {
        return this.databaseFacade;
    }

    public DatabaseHealth getDatabaseHealth() {
        return this.databaseHealth;
    }

    public VersionContextSupplier getVersionContextSupplier() {
        return this.versionContextSupplier;
    }

    public StorageEngineFactory getStorageEngineFactory() {
        return this.storageEngineFactory;
    }

    private void prepareStop(Predicate<PagedFile> deleteFilePredicate) {
        this.databasePageCache.listExistingMappings().stream().filter(deleteFilePredicate).forEach(file -> file.setDeleteOnClose(true));
    }

    private long getAwaitActiveTransactionDeadlineMillis() {
        return ((Duration)this.databaseConfig.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)).toMillis();
    }

    @VisibleForTesting
    public LifeSupport getLife() {
        return this.life;
    }

    public static Iterable<IndexDescriptor> initialSchemaRulesLoader(StorageEngine storageEngine) {
        return () -> {
            try (StorageReader reader = storageEngine.newReader();){
                Iterator iterator = Iterators.asList((Iterator)reader.indexesGetAll()).iterator();
                return iterator;
            }
        };
    }

    public boolean isStarted() {
        return this.started;
    }

    private static void safeStorageEngineClose(StorageEngine storageEngine) {
        if (storageEngine != null) {
            storageEngine.forceClose();
        }
    }

    private static void safePoolRelease(ScopedMemoryPool pool) {
        if (pool != null) {
            pool.close();
        }
    }

    private static void safeLifeShutdown(LifeSupport life) {
        if (life != null) {
            life.shutdown();
        }
    }
}

