/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public class ReversedMultiFileTransactionCursor
implements TransactionCursor {
    private final LogPosition backToPosition;
    private final LogFile logFile;
    private final ThrowingFunction<LogPosition, TransactionCursor, IOException> cursorFactory;
    private long currentVersion;
    private TransactionCursor currentLogTransactionCursor;

    public static TransactionCursor fromLogFile(LogFile logFile, LogPosition backToPosition, LogEntryReader logEntryReader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) {
        long highestVersion = logFile.getHighestLogVersion();
        ThrowingFunction factory = position -> {
            ReadableLogChannel channel = logFile.getReader((LogPosition)position, LogVersionBridge.NO_MORE_CHANNELS);
            if (channel instanceof ReadAheadLogChannel) {
                return new ReversedSingleFileTransactionCursor((ReadAheadLogChannel)channel, logEntryReader, failOnCorruptedLogFiles, monitor);
            }
            return EagerlyReversedTransactionCursor.eagerlyReverse(new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)channel, logEntryReader));
        };
        return new ReversedMultiFileTransactionCursor(logFile, (ThrowingFunction<LogPosition, TransactionCursor, IOException>)factory, highestVersion, backToPosition);
    }

    ReversedMultiFileTransactionCursor(LogFile logFile, ThrowingFunction<LogPosition, TransactionCursor, IOException> cursorFactory, long highestVersion, LogPosition backToPosition) {
        this.logFile = logFile;
        this.cursorFactory = cursorFactory;
        this.backToPosition = backToPosition;
        this.currentVersion = highestVersion + 1L;
    }

    public CommittedTransactionRepresentation get() {
        return (CommittedTransactionRepresentation)this.currentLogTransactionCursor.get();
    }

    public boolean next() throws IOException {
        while (this.currentLogTransactionCursor == null || !this.currentLogTransactionCursor.next()) {
            --this.currentVersion;
            if (this.currentVersion < this.backToPosition.getLogVersion()) {
                return false;
            }
            this.closeCurrent();
            LogPosition position = this.currentVersion > this.backToPosition.getLogVersion() ? this.logFile.extractHeader(this.currentVersion).getStartPosition() : this.backToPosition;
            this.currentLogTransactionCursor = (TransactionCursor)this.cursorFactory.apply((Object)position);
        }
        return true;
    }

    public void close() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.currentLogTransactionCursor != null) {
            this.currentLogTransactionCursor.close();
            this.currentLogTransactionCursor = null;
        }
    }

    @Override
    public LogPosition position() {
        return this.currentLogTransactionCursor.position();
    }
}

