/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.index.schema.TokenScan;
import org.neo4j.kernel.impl.newapi.BaseCursorScan;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.Read;

class NodeLabelIndexCursorScan
extends BaseCursorScan<NodeLabelIndexCursor, TokenScan> {
    private final LongSet removed;
    private final int label;

    NodeLabelIndexCursorScan(Read read, int label, TokenScan tokenScan, CursorContext cursorContext) {
        super(tokenScan, read, () -> read.txState().nodesWithLabelChanged(label).getAdded().toArray(), cursorContext);
        this.label = label;
        if (this.hasChanges) {
            TransactionState txState = read.txState();
            this.removed = PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)txState.nodesWithLabelChanged(label).getRemoved());
        } else {
            this.removed = LongSets.immutable.empty();
        }
    }

    @Override
    protected boolean scanStore(NodeLabelIndexCursor cursor, int sizeHint, LongIterator addedItems) {
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this.read);
        IndexProgressor indexProgressor = ((TokenScan)this.storageScan).initializeBatch((IndexProgressor.EntityTokenClient)indexCursor, sizeHint, this.cursorContext);
        if (indexProgressor == IndexProgressor.EMPTY && !addedItems.hasNext()) {
            return false;
        }
        indexCursor.initialize(indexProgressor, this.label, addedItems, this.removed);
        return true;
    }
}

