/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.map.primitive.LongIntMap;
import org.neo4j.collection.pool.Pool;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongIntHashMap;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.forseti.ExclusiveLock;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.locking.forseti.SharedLock;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.lock.AcquireLockTimeoutException;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.lock.WaitStrategy;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.SystemNanoClock;

public class ForsetiClient
implements Locks.Client {
    static final int NO_CLIENT_ID = -1;
    private final int clientId;
    private final ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps;
    private final WaitStrategy[] waitStrategies;
    private final ForsetiLockManager.DeadlockResolutionStrategy deadlockResolutionStrategy;
    private final Pool<ForsetiClient> clientPool;
    private final IntFunction<ForsetiClient> clientById;
    private final HeapTrackingLongIntHashMap[] sharedLockCounts;
    private final HeapTrackingLongIntHashMap[] exclusiveLockCounts;
    private long lockAcquisitionTimeoutNano;
    private final SystemNanoClock clock;
    private final boolean verboseDeadlocks;
    private final SimpleBitSet waitList = new SimpleBitSet(64);
    private long waitListCheckPoint;
    private final LockClientStateHolder stateHolder = new LockClientStateHolder();
    private ExclusiveLock myExclusiveLock;
    private volatile boolean hasLocks;
    private final ReleaseExclusiveLocksAndClearSharedVisitor releaseExclusiveAndClearSharedVisitor = new ReleaseExclusiveLocksAndClearSharedVisitor();
    private final ReleaseSharedDontCheckExclusiveVisitor releaseSharedDontCheckExclusiveVisitor = new ReleaseSharedDontCheckExclusiveVisitor();
    private volatile ForsetiLockManager.Lock waitingForLock;
    private volatile long userTransactionId;
    private volatile MemoryTracker memoryTracker;
    private static final long CONCURRENT_NODE_SIZE = (long)HeapEstimator.LONG_SIZE + HeapEstimator.HASH_MAP_NODE_SHALLOW_SIZE;

    public ForsetiClient(int id, ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps, WaitStrategy[] waitStrategies, Pool<ForsetiClient> clientPool, ForsetiLockManager.DeadlockResolutionStrategy deadlockResolutionStrategy, IntFunction<ForsetiClient> clientById, SystemNanoClock clock, boolean verboseDeadlocks) {
        this.clientId = id;
        this.lockMaps = lockMaps;
        this.waitStrategies = waitStrategies;
        this.deadlockResolutionStrategy = deadlockResolutionStrategy;
        this.clientPool = clientPool;
        this.clientById = clientById;
        this.sharedLockCounts = new HeapTrackingLongIntHashMap[lockMaps.length];
        this.exclusiveLockCounts = new HeapTrackingLongIntHashMap[lockMaps.length];
        this.clock = clock;
        this.verboseDeadlocks = verboseDeadlocks;
    }

    public void reset() {
        this.stateHolder.reset();
    }

    @Override
    public void initialize(LeaseClient leaseClient, long transactionId, MemoryTracker memoryTracker, Config config) {
        this.userTransactionId = transactionId;
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.lockAcquisitionTimeoutNano = ((Duration)config.get(GraphDatabaseSettings.lock_acquisition_timeout)).toNanos();
        this.myExclusiveLock = new ExclusiveLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        LockWaitEvent waitEvent = null;
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap heldShareLocks = this.getSharedLockCount(resourceType);
            HeapTrackingLongIntHashMap heldExclusiveLocks = this.getExclusiveLockCount(resourceType);
            for (long resourceId : resourceIds) {
                int heldCount = heldShareLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    continue;
                }
                int tries = 0;
                SharedLock mySharedLock = null;
                long waitStartNano = this.clock.nanos();
                while (true) {
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (mySharedLock == null) {
                            mySharedLock = new SharedLock(this);
                        }
                        if (lockMap.putIfAbsent(resourceId, mySharedLock) != null) continue;
                        break;
                    }
                    if (existingLock instanceof SharedLock) {
                        if (((SharedLock)existingLock).acquire(this)) {
                            break;
                        }
                    } else if (!(existingLock instanceof ExclusiveLock)) {
                        throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                    }
                    if (waitEvent == null) {
                        waitEvent = tracer.waitForLock(LockType.SHARED, resourceType, this.userTransactionId, new long[]{resourceId});
                    }
                    this.waitFor(existingLock, resourceType, resourceId, tries++);
                }
                heldShareLocks.put(resourceId, 1);
                this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
            }
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.clearWaitList();
            this.waitingForLock = null;
            this.stateHolder.decrementActiveClients();
        }
    }

    private HeapTrackingLongIntHashMap getSharedLockCount(ResourceType resourceType) {
        HeapTrackingLongIntHashMap sharedLockCount = this.sharedLockCounts[resourceType.typeId()];
        if (sharedLockCount == null) {
            this.sharedLockCounts[resourceType.typeId()] = sharedLockCount = HeapTrackingCollections.newLongIntMap((MemoryTracker)this.memoryTracker);
        }
        return sharedLockCount;
    }

    private HeapTrackingLongIntHashMap getExclusiveLockCount(ResourceType resourceType) {
        HeapTrackingLongIntHashMap exclusiveLockCount = this.exclusiveLockCounts[resourceType.typeId()];
        if (exclusiveLockCount == null) {
            this.exclusiveLockCounts[resourceType.typeId()] = exclusiveLockCount = HeapTrackingCollections.newLongIntMap((MemoryTracker)this.memoryTracker);
        }
        return exclusiveLockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        LockWaitEvent waitEvent = null;
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap heldLocks = this.getExclusiveLockCount(resourceType);
            for (long resourceId : resourceIds) {
                ForsetiLockManager.Lock existingLock;
                int heldCount = heldLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                int tries = 0;
                long waitStartNano = this.clock.nanos();
                boolean upgraded = false;
                while ((existingLock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock)) != null) {
                    SharedLock sharedLock;
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    if (tries > 50 && existingLock instanceof SharedLock && this.tryUpgradeSharedToExclusive(tracer, waitEvent, resourceType, lockMap, resourceId, sharedLock = (SharedLock)existingLock, waitStartNano)) {
                        upgraded = true;
                        break;
                    }
                    if (waitEvent == null) {
                        waitEvent = tracer.waitForLock(LockType.EXCLUSIVE, resourceType, this.userTransactionId, new long[]{resourceId});
                    }
                    this.waitFor(existingLock, resourceType, resourceId, tries++);
                }
                heldLocks.put(resourceId, 1);
                if (upgraded) continue;
                this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
            }
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.clearWaitList();
            this.waitingForLock = null;
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap heldLocks = this.getExclusiveLockCount(resourceType);
            int heldCount = heldLocks.getIfAbsent(resourceId, -1);
            if (heldCount != -1) {
                heldLocks.put(resourceId, Math.incrementExact(heldCount));
                boolean bl = true;
                return bl;
            }
            ForsetiLockManager.Lock lock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock);
            if (lock != null) {
                SharedLock sharedLock;
                if (lock instanceof SharedLock && this.getSharedLockCount(resourceType).containsKey(resourceId) && (sharedLock = (SharedLock)lock).tryAcquireUpdateLock(this)) {
                    if (sharedLock.numberOfHolders() == 1) {
                        heldLocks.put(resourceId, 1);
                        boolean bl = true;
                        return bl;
                    }
                    sharedLock.releaseUpdateLock();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            heldLocks.put(resourceId, 1);
            this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        try {
            HeapTrackingLongIntHashMap heldShareLocks;
            block12: {
                ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
                heldShareLocks = this.getSharedLockCount(resourceType);
                HeapTrackingLongIntHashMap heldExclusiveLocks = this.getExclusiveLockCount(resourceType);
                int heldCount = heldShareLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    boolean bl = true;
                    return bl;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    boolean bl = true;
                    return bl;
                }
                long waitStartNano = this.clock.nanos();
                while (true) {
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (lockMap.putIfAbsent(resourceId, new SharedLock(this)) != null) continue;
                        break block12;
                    }
                    if (!(existingLock instanceof SharedLock)) {
                        if (!(existingLock instanceof ExclusiveLock)) throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                        boolean bl = false;
                        return bl;
                    }
                    if (((SharedLock)existingLock).acquire(this)) break block12;
                    if (((SharedLock)existingLock).isUpdateLock()) break;
                }
                boolean bl = false;
                return bl;
            }
            heldShareLocks.put(resourceId, 1);
            this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            HeapTrackingLongIntHashMap sharedLocks = this.getSharedLockCount(resourceType);
            HeapTrackingLongIntHashMap exclusiveLocks = this.getExclusiveLockCount(resourceType);
            ConcurrentMap<Long, ForsetiLockManager.Lock> resourceTypeLocks = this.lockMaps[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                if (this.releaseLocalLock(resourceType, resourceId, sharedLocks) || exclusiveLocks.containsKey(resourceId)) continue;
                this.releaseGlobalLock(resourceTypeLocks, resourceId);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> resourceTypeLocks = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap exclusiveLocks = this.getExclusiveLockCount(resourceType);
            HeapTrackingLongIntHashMap sharedLocks = this.getSharedLockCount(resourceType);
            for (long resourceId : resourceIds) {
                if (this.releaseLocalLock(resourceType, resourceId, exclusiveLocks)) continue;
                if (sharedLocks.containsKey(resourceId)) {
                    SharedLock sharedLock;
                    ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)resourceTypeLocks.get(resourceId);
                    if (lock instanceof SharedLock) {
                        sharedLock = (SharedLock)lock;
                        if (sharedLock.isUpdateLock()) {
                            sharedLock.releaseUpdateLock();
                            continue;
                        }
                        throw new IllegalStateException("Incorrect state of exclusive lock. Lock should be updated to exclusive before attempt to release it. Lock: " + this);
                    }
                    sharedLock = new SharedLock(this);
                    resourceTypeLocks.put(resourceId, sharedLock);
                    continue;
                }
                this.releaseGlobalLock(resourceTypeLocks, resourceId);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    private void releaseAllClientLocks() {
        for (int i = 0; i < this.exclusiveLockCounts.length; ++i) {
            HeapTrackingLongIntHashMap exclusiveLocks = this.exclusiveLockCounts[i];
            HeapTrackingLongIntHashMap sharedLocks = this.sharedLockCounts[i];
            if (exclusiveLocks != null) {
                exclusiveLocks.forEachKey(this.releaseExclusiveAndClearSharedVisitor.initialize(sharedLocks, this.lockMaps[i]));
                this.exclusiveLockCounts[i] = null;
                exclusiveLocks.close();
            }
            if (sharedLocks == null) continue;
            sharedLocks.forEachKey(this.releaseSharedDontCheckExclusiveVisitor.initialize(this.lockMaps[i]));
            this.sharedLockCounts[i] = null;
            sharedLocks.close();
        }
    }

    @Override
    public void prepareForCommit() {
        this.stateHolder.prepare(this);
    }

    @Override
    public void stop() {
        if (this.stateHolder.stopClient()) {
            this.waitForAllClientsToLeave();
            this.releaseAllLocks();
        }
    }

    private void waitForAllClientsToLeave() {
        while (this.stateHolder.hasActiveClients()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public void close() {
        this.stateHolder.closeClient();
        this.waitForAllClientsToLeave();
        this.releaseAllLocks();
        this.userTransactionId = -1L;
        this.memoryTracker = null;
        this.myExclusiveLock.close();
        this.clientPool.release((Object)this);
    }

    private void releaseAllLocks() {
        if (this.hasLocks) {
            this.releaseAllClientLocks();
            this.clearWaitList();
            this.hasLocks = false;
        }
    }

    @Override
    public int getLockSessionId() {
        return this.clientId;
    }

    public Stream<ActiveLock> activeLocks() {
        ArrayList<ActiveLock> locks = new ArrayList<ActiveLock>();
        ForsetiClient.collectActiveLocks((LongIntMap[])this.exclusiveLockCounts, locks, LockType.EXCLUSIVE, this.userTransactionId);
        ForsetiClient.collectActiveLocks((LongIntMap[])this.sharedLockCounts, locks, LockType.SHARED, this.userTransactionId);
        return locks.stream();
    }

    public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
        ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resource.typeId()];
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(id);
        return lock != null && lock.isOwnedBy(this) && (lock.type() == lockType || lock.type() == LockType.EXCLUSIVE);
    }

    @Override
    public long activeLockCount() {
        return ForsetiClient.countLocks((LongIntMap[])this.exclusiveLockCounts) + ForsetiClient.countLocks((LongIntMap[])this.sharedLockCounts);
    }

    private static void collectActiveLocks(LongIntMap[] counts, List<ActiveLock> locks, LockType lockType, long userTransactionId) {
        for (int typeId = 0; typeId < counts.length; ++typeId) {
            LongIntMap lockCounts = counts[typeId];
            if (lockCounts == null) continue;
            ResourceType resourceType = ResourceTypes.fromId((int)typeId);
            lockCounts.forEachKeyValue((LongIntProcedure & Serializable)(resourceId, count) -> locks.add(new ActiveLock(resourceType, lockType, userTransactionId, resourceId)));
        }
    }

    private static long countLocks(LongIntMap[] lockCounts) {
        long count = 0L;
        for (LongIntMap lockCount : lockCounts) {
            if (lockCount == null) continue;
            count += (long)lockCount.size();
        }
        return count;
    }

    int waitListSize() {
        return this.waitList.size();
    }

    void copyWaitListTo(SimpleBitSet other) {
        other.put(this.waitList);
    }

    boolean isWaitingFor(int clientId) {
        return clientId != this.clientId && this.waitList.contains(clientId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForsetiClient that = (ForsetiClient)o;
        return this.clientId == that.clientId;
    }

    public int hashCode() {
        return this.clientId;
    }

    public String toString() {
        return String.format("ForsetiClient[%d]", this.clientId);
    }

    private void releaseGlobalLock(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId) {
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
        if (lock instanceof ExclusiveLock) {
            lockMap.remove(resourceId);
            this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
        } else if (lock instanceof SharedLock && ((SharedLock)lock).release(this)) {
            ((SharedLock)lock).cleanUpdateHolder();
            lockMap.remove(resourceId);
            this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
        }
    }

    private boolean releaseLocalLock(ResourceType type, long resourceId, HeapTrackingLongIntHashMap localLocks) {
        int lockCount = localLocks.removeKeyIfAbsent(resourceId, -1);
        if (lockCount == -1) {
            throw new IllegalStateException(this + " cannot release lock that it does not hold: " + type + "[" + resourceId + "].");
        }
        if (lockCount > 1) {
            localLocks.put(resourceId, lockCount - 1);
            return true;
        }
        return false;
    }

    private boolean tryUpgradeSharedToExclusive(LockTracer tracer, LockWaitEvent waitEvent, ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock, long waitStartNano) throws AcquireLockTimeoutException {
        int tries = 0;
        boolean holdsSharedLock = this.getSharedLockCount(resourceType).containsKey(resourceId);
        if (!holdsSharedLock) {
            if (!sharedLock.acquire(this)) {
                return false;
            }
            this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
            try {
                if (this.tryUpgradeToExclusiveWithShareLockHeld(tracer, waitEvent, resourceType, resourceId, sharedLock, tries, waitStartNano)) {
                    return true;
                }
                this.releaseGlobalLock(lockMap, resourceId);
                return false;
            }
            catch (Throwable e) {
                this.releaseGlobalLock(lockMap, resourceId);
                throw e;
            }
        }
        return this.tryUpgradeToExclusiveWithShareLockHeld(tracer, waitEvent, resourceType, resourceId, sharedLock, tries, waitStartNano);
    }

    private boolean tryUpgradeToExclusiveWithShareLockHeld(LockTracer tracer, LockWaitEvent priorEvent, ResourceType resourceType, long resourceId, SharedLock sharedLock, int tries, long waitStartNano) throws AcquireLockTimeoutException {
        if (sharedLock.tryAcquireUpdateLock(this)) {
            LockWaitEvent waitEvent = null;
            try {
                while (sharedLock.numberOfHolders() > 1) {
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    if (waitEvent == null && priorEvent == null) {
                        waitEvent = tracer.waitForLock(LockType.EXCLUSIVE, resourceType, this.userTransactionId, new long[]{resourceId});
                    }
                    this.waitFor(sharedLock, resourceType, resourceId, tries++);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                sharedLock.releaseUpdateLock();
                if (e instanceof DeadlockDetectedException || e instanceof LockClientStoppedException) {
                    throw (RuntimeException)e;
                }
                throw new TransactionFailureException("Failed to upgrade shared lock to exclusive: " + sharedLock, e);
            }
            finally {
                if (waitEvent != null) {
                    waitEvent.close();
                }
                this.clearWaitList();
                this.waitingForLock = null;
            }
        }
        return false;
    }

    private void clearWaitList() {
        this.waitListCheckPoint = this.waitList.checkPointAndPut(this.waitListCheckPoint, this.clientId);
    }

    private void waitFor(ForsetiLockManager.Lock lock, ResourceType type, long resourceId, int tries) {
        this.waitingForLock = lock;
        this.clearAndCopyWaitList(lock);
        this.waitStrategies[type.typeId()].apply((long)tries);
        int id = lock.detectDeadlock(this.id());
        if (id != -1 && this.deadlockResolutionStrategy.shouldAbort(this, this.clientById.apply(id))) {
            if (tries > 100 && this.isDeadlockReal(lock)) {
                String message = this + " can't acquire " + lock + " on " + type + "(" + resourceId + "), because holders of that lock are waiting for " + this + ".\n Wait list:" + lock.describeWaitList();
                if (this.verboseDeadlocks) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(" All locks:[");
                    for (int i = 0; i < this.lockMaps.length; ++i) {
                        sb.append(ResourceTypes.fromId((int)i)).append("[");
                        sb.append(this.lockMaps[i]).append("]");
                    }
                    sb.append("]");
                    message = message + sb.toString();
                }
                throw new DeadlockDetectedException(message);
            }
            Thread.yield();
        }
    }

    private void clearAndCopyWaitList(ForsetiLockManager.Lock lock) {
        this.clearWaitList();
        lock.copyHolderWaitListsInto(this.waitList);
    }

    private boolean isDeadlockReal(ForsetiLockManager.Lock lock) {
        if (this.isDeadlockRealInternal(lock)) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            return this.isDeadlockRealInternal(lock);
        }
        return false;
    }

    private boolean isDeadlockRealInternal(ForsetiLockManager.Lock lock) {
        HashSet<ForsetiLockManager.Lock> waitedUpon = new HashSet<ForsetiLockManager.Lock>();
        HashSet<ForsetiClient> owners = new HashSet<ForsetiClient>();
        HashSet<ForsetiLockManager.Lock> nextWaitedUpon = new HashSet<ForsetiLockManager.Lock>();
        HashSet<ForsetiClient> nextOwners = new HashSet<ForsetiClient>();
        lock.collectOwners(owners);
        do {
            waitedUpon.addAll(nextWaitedUpon);
            ForsetiClient.collectNextOwners(waitedUpon, owners, nextWaitedUpon, nextOwners);
            if (nextOwners.contains(this) && lock.detectDeadlock(this.id()) != -1) {
                return true;
            }
            owners.clear();
            HashSet<ForsetiClient> ownersTmp = owners;
            owners = nextOwners;
            nextOwners = ownersTmp;
        } while (!nextWaitedUpon.isEmpty());
        return false;
    }

    private static void collectNextOwners(Set<ForsetiLockManager.Lock> waitedUpon, Set<ForsetiClient> owners, Set<ForsetiLockManager.Lock> nextWaitedUpon, Set<ForsetiClient> nextOwners) {
        nextWaitedUpon.clear();
        for (ForsetiClient owner : owners) {
            ForsetiLockManager.Lock waitingForLock = owner.waitingForLock;
            if (waitingForLock == null || waitingForLock.isClosed() || waitedUpon.contains(waitingForLock)) continue;
            nextWaitedUpon.add(waitingForLock);
        }
        for (ForsetiLockManager.Lock lck : nextWaitedUpon) {
            lck.collectOwners(nextOwners);
        }
    }

    String describeWaitList() {
        StringBuilder sb = new StringBuilder(String.format("%nClient[%d] waits for [", this.id()));
        IntIterator iter = this.waitList.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            int next = iter.next();
            if (next == this.clientId) continue;
            sb.append(!first ? "," : "").append(next);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public int id() {
        return this.clientId;
    }

    private void assertValid(long waitStartNano, ResourceType resourceType, long resourceId) {
        this.assertNotStopped();
        this.assertNotExpired(waitStartNano, resourceType, resourceId);
    }

    private void assertNotStopped() {
        if (this.stateHolder.isStopped()) {
            throw new LockClientStoppedException(this);
        }
    }

    private void assertNotExpired(long waitStartNano, ResourceType resourceType, long resourceId) {
        long timeoutNano = this.lockAcquisitionTimeoutNano;
        if (timeoutNano > 0L && this.clock.nanos() - waitStartNano > timeoutNano) {
            throw new LockAcquisitionTimeoutException(resourceType, resourceId, timeoutNano);
        }
    }

    public long transactionId() {
        return this.userTransactionId;
    }

    private class ReleaseExclusiveLocksAndClearSharedVisitor
    implements LongProcedure {
        private HeapTrackingLongIntHashMap sharedLockCounts;
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseExclusiveLocksAndClearSharedVisitor() {
        }

        private LongProcedure initialize(HeapTrackingLongIntHashMap sharedLockCounts, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.sharedLockCounts = sharedLockCounts;
            this.lockMap = lockMap;
            return this;
        }

        public void value(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            if (this.sharedLockCounts != null) {
                this.sharedLockCounts.remove(resourceId);
            }
        }
    }

    private class ReleaseSharedDontCheckExclusiveVisitor
    implements LongProcedure {
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseSharedDontCheckExclusiveVisitor() {
        }

        private LongProcedure initialize(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.lockMap = lockMap;
            return this;
        }

        public void value(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
        }
    }
}

