/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexMonitorAdaptor;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.kernel.impl.index.schema.TokenScanWriteMonitor;
import org.neo4j.monitoring.Monitors;
import org.neo4j.util.Preconditions;

public class TokenIndex
implements ConsistencyCheckable {
    static final WriteMonitor EMPTY = new WriteMonitor(){};
    private static final byte CLEAN = 0;
    static final byte ONLINE = 0;
    private static final byte NEEDS_REBUILDING = 1;
    static final byte POPULATING = 1;
    static final byte FAILED = 2;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final Monitors monitors;
    private final String monitorTag;
    private final PageCache pageCache;
    final IndexFiles indexFiles;
    final FileSystemAbstraction fs;
    private final PageCacheTracer cacheTracer;
    private final String databaseName;
    GBPTree<TokenScanKey, TokenScanValue> index;
    TokenIndexUpdater singleUpdater;
    WriteMonitor writeMonitor;
    private final String tokenStoreName;
    private final IndexDescriptor monitoringDescriptor;

    public TokenIndex(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexDescriptor descriptor) {
        this.readOnlyChecker = databaseIndexContext.readOnlyChecker;
        this.monitors = databaseIndexContext.monitors;
        this.monitorTag = databaseIndexContext.monitorTag;
        this.pageCache = databaseIndexContext.pageCache;
        this.fs = databaseIndexContext.fileSystem;
        this.cacheTracer = databaseIndexContext.pageCacheTracer;
        this.databaseName = databaseIndexContext.databaseName;
        this.indexFiles = indexFiles;
        this.tokenStoreName = descriptor.getName();
        this.monitoringDescriptor = descriptor;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) {
        GBPTree.Monitor monitor = this.treeMonitor();
        this.index = new GBPTree(this.pageCache, this.indexFiles.getStoreFile(), (Layout)new TokenScanLayout(), monitor, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector, this.readOnlyChecker, this.cacheTracer, Sets.immutable.empty(), this.databaseName, this.tokenStoreName);
    }

    void instantiateUpdater(Config config, DatabaseLayout directoryStructure, EntityType entityType) {
        this.writeMonitor = (Boolean)config.get(GraphDatabaseInternalSettings.token_scan_write_log_enabled) != false ? new TokenScanWriteMonitor(this.fs, directoryStructure, entityType, config) : EMPTY;
        this.singleUpdater = new TokenIndexUpdater(1000, this.writeMonitor);
    }

    private GBPTree.Monitor treeMonitor() {
        GBPTree.Monitor treeMonitor = (GBPTree.Monitor)this.monitors.newMonitor(GBPTree.Monitor.class, new String[]{this.monitorTag});
        IndexProvider.Monitor indexMonitor = (IndexProvider.Monitor)this.monitors.newMonitor(IndexProvider.Monitor.class, new String[]{this.monitorTag});
        return new IndexMonitorAdaptor(treeMonitor, indexMonitor, this.indexFiles, this.monitoringDescriptor);
    }

    void closeResources() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new Closeable[]{this.index, this.writeMonitor});
        this.index = null;
        this.writeMonitor = null;
    }

    void assertTreeOpen() {
        Preconditions.checkState((this.index != null ? 1 : 0) != 0, (String)"Index tree has been closed or was never instantiated.");
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<TokenScanKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)), cursorContext);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<TokenScanKey> visitor, CursorContext cursorContext) {
        try {
            return this.index.consistencyCheck(visitor, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static interface WriteMonitor
    extends Closeable {
        default public void range(long range, int tokenId) {
        }

        default public void prepareAdd(long txId, int offset) {
        }

        default public void prepareRemove(long txId, int offset) {
        }

        default public void mergeAdd(TokenScanValue existingValue, TokenScanValue newValue) {
        }

        default public void mergeRemove(TokenScanValue existingValue, TokenScanValue newValue) {
        }

        default public void flushPendingUpdates() {
        }

        default public void writeSessionEnded() {
        }

        default public void force() {
        }

        @Override
        default public void close() {
        }
    }
}

