/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.state.EntityStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.TrackableDiffSets;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.values.storable.Value;

class NodeStateImpl
extends EntityStateImpl
implements NodeState {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeStateImpl.class);
    static final NodeState EMPTY = new NodeState(){

        public Iterator<StorageProperty> addedProperties() {
            return Collections.emptyIterator();
        }

        public Iterator<StorageProperty> changedProperties() {
            return Collections.emptyIterator();
        }

        public IntIterable removedProperties() {
            return IntSets.immutable.empty();
        }

        public Iterator<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyIterator();
        }

        public boolean hasPropertyChanges() {
            return false;
        }

        public LongDiffSets labelDiffSets() {
            return LongDiffSets.EMPTY;
        }

        public int augmentDegree(RelationshipDirection direction, int degree, int typeId) {
            return degree;
        }

        public long getId() {
            throw new UnsupportedOperationException("id not defined");
        }

        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }

        public Value propertyValue(int propertyKey) {
            return null;
        }

        public LongIterator getAddedRelationships() {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public LongIterator getAddedRelationships(Direction direction) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public LongIterator getAddedRelationships(Direction direction, int relType) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public IntIterable getAddedRelationshipTypes() {
            return IntSets.immutable.empty();
        }

        public IntIterable getAddedAndRemovedRelationshipTypes() {
            return IntSets.immutable.empty();
        }
    };
    private final boolean addedInThisTx;
    private MutableLongDiffSets labelDiffSets;
    private RelationshipChangesForNode relationshipsAdded;
    private RelationshipChangesForNode relationshipsRemoved;
    private boolean deleted;

    static NodeStateImpl createNodeState(long id, boolean addedInThisTx, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new NodeStateImpl(id, addedInThisTx, collectionsFactory, memoryTracker);
    }

    private NodeStateImpl(long id, boolean addedInThisTx, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        super(id, collectionsFactory, memoryTracker);
        this.addedInThisTx = addedInThisTx;
    }

    public LongDiffSets labelDiffSets() {
        return this.labelDiffSets == null ? LongDiffSets.EMPTY : this.labelDiffSets;
    }

    MutableLongDiffSets getOrCreateLabelDiffSets() {
        if (this.labelDiffSets == null) {
            this.labelDiffSets = TrackableDiffSets.newMutableLongDiffSets(this.collectionsFactory, this.memoryTracker);
        }
        return this.labelDiffSets;
    }

    public void addRelationship(long relId, int typeId, RelationshipDirection direction) {
        if (!this.hasAddedRelationships()) {
            this.relationshipsAdded = RelationshipChangesForNode.createRelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, this.memoryTracker);
        }
        this.relationshipsAdded.addRelationship(relId, typeId, direction);
    }

    public void removeRelationship(long relId, int typeId, RelationshipDirection direction) {
        if (this.hasAddedRelationships() && this.relationshipsAdded.removeRelationship(relId, typeId, direction)) {
            return;
        }
        if (!this.hasRemovedRelationships()) {
            this.relationshipsRemoved = RelationshipChangesForNode.createRelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.REMOVE, this.memoryTracker);
        }
        this.relationshipsRemoved.addRelationship(relId, typeId, direction);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.labelDiffSets != null) {
            this.labelDiffSets = null;
        }
    }

    public int augmentDegree(RelationshipDirection direction, int degree, int typeId) {
        if (this.hasAddedRelationships()) {
            degree = this.relationshipsAdded.augmentDegree(direction, degree, typeId);
        }
        if (this.hasRemovedRelationships()) {
            degree = this.relationshipsRemoved.augmentDegree(direction, degree, typeId);
        }
        return degree;
    }

    boolean hasAddedRelationships() {
        return this.relationshipsAdded != null && !this.relationshipsAdded.isEmpty();
    }

    public boolean hasAddedRelationships(int type) {
        return this.relationshipsAdded.hasRelationships(type);
    }

    boolean hasRemovedRelationships() {
        return this.relationshipsRemoved != null && !this.relationshipsRemoved.isEmpty();
    }

    public LongIterator getAddedRelationships() {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships() : ImmutableEmptyLongIterator.INSTANCE;
    }

    public LongIterator getAddedRelationships(Direction direction) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction) : ImmutableEmptyLongIterator.INSTANCE;
    }

    public LongIterator getAddedRelationships(Direction direction, int relType) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction, relType) : ImmutableEmptyLongIterator.INSTANCE;
    }

    public IntIterable getAddedRelationshipTypes() {
        return this.relationshipsAdded != null ? this.relationshipsAdded.relationshipTypes() : IntSets.immutable.empty();
    }

    public IntIterable getAddedAndRemovedRelationshipTypes() {
        if (this.relationshipsAdded == null && this.relationshipsRemoved == null) {
            return IntSets.immutable.empty();
        }
        if (this.relationshipsAdded != null && this.relationshipsRemoved != null) {
            MutableIntSet types = IntSets.mutable.withAll((IntIterable)this.relationshipsAdded.relationshipTypes());
            types.addAll((IntIterable)this.relationshipsRemoved.relationshipTypes());
            return types;
        }
        return this.relationshipsAdded != null ? this.relationshipsAdded.relationshipTypes() : this.relationshipsRemoved.relationshipTypes();
    }

    RelationshipModifications.RelationshipBatch additionsAsRelationshipBatch(RelationshipModifications.IdDataDecorator decorator) {
        return new RelationshipBatchImpl(this.relationshipsAdded, decorator);
    }

    RelationshipModifications.RelationshipBatch removalsAsRelationshipBatch(RelationshipModifications.IdDataDecorator decorator) {
        return new RelationshipBatchImpl(this.relationshipsRemoved, decorator);
    }

    void visitAddedIdsSplit(RelationshipModifications.InterruptibleTypeIdsVisitor visitor, RelationshipModifications.IdDataDecorator idDataDecorator) {
        if (this.hasAddedRelationships()) {
            this.relationshipsAdded.visitIdsSplit(visitor, idDataDecorator);
        }
    }

    void visitRemovedIdsSplit(RelationshipModifications.InterruptibleTypeIdsVisitor visitor) {
        if (this.hasRemovedRelationships()) {
            this.relationshipsRemoved.visitIdsSplit(visitor, RelationshipModifications.noAdditionalDataDecorator());
        }
    }

    boolean isDeleted() {
        return this.deleted;
    }

    boolean isAddedInThisTx() {
        return this.addedInThisTx;
    }

    void markAsDeleted() {
        this.deleted = true;
        this.clear();
    }

    private static class RelationshipBatchImpl
    implements RelationshipModifications.RelationshipBatch {
        private final RelationshipChangesForNode relationships;
        private final RelationshipModifications.IdDataDecorator decorator;

        RelationshipBatchImpl(RelationshipChangesForNode relationships, RelationshipModifications.IdDataDecorator decorator) {
            this.relationships = relationships;
            this.decorator = decorator;
        }

        public int size() {
            return this.relationships != null ? this.relationships.totalCount() : 0;
        }

        public boolean isEmpty() {
            return this.relationships == null;
        }

        public <E extends Exception> void forEach(RelationshipVisitor<E> relationship) throws E {
            this.relationships.visitIds(id -> this.decorator.accept(id, relationship));
        }
    }
}

