/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.impl.schema.IndexProviderFactoryUtil;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSlotSelector30;
import org.neo4j.monitoring.Monitors;
import org.neo4j.util.VisibleForTesting;

public class NativeLuceneFusionIndexProviderFactory30
extends AbstractIndexProviderFactory {
    public static final String KEY = GraphDatabaseSettings.SchemaIndex.NATIVE30.providerKey();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, GraphDatabaseSettings.SchemaIndex.NATIVE30.providerVersion());

    public NativeLuceneFusionIndexProviderFactory30() {
        super(KEY);
    }

    @Override
    protected Class<?> loggingClass() {
        return FusionIndexProvider.class;
    }

    @Override
    public IndexProviderDescriptor descriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected IndexProvider internalCreate(PageCache pageCache, Path storeDir, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer) {
        return NativeLuceneFusionIndexProviderFactory30.create(pageCache, storeDir, fs, monitors, monitorTag, config, readOnlyChecker, recoveryCleanupWorkCollector, pageCacheTracer, databaseLayout.getDatabaseName());
    }

    @VisibleForTesting
    public static FusionIndexProvider create(PageCache pageCache, Path databaseDirectory, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer pageCacheTracer, String databaseName) {
        IndexDirectoryStructure.Factory childDirectoryStructure = NativeLuceneFusionIndexProviderFactory30.subProviderDirectoryStructure(databaseDirectory);
        boolean archiveFailedIndex = (Boolean)config.get(GraphDatabaseInternalSettings.archive_failed_index);
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder(pageCache, fs, databaseName).withMonitors(monitors).withTag(monitorTag).withReadOnlyChecker(readOnlyChecker).withPageCacheTracer(pageCacheTracer).build();
        GenericNativeIndexProvider generic = new GenericNativeIndexProvider(databaseIndexContext, childDirectoryStructure, recoveryCleanupWorkCollector, config);
        LuceneIndexProvider lucene = IndexProviderFactoryUtil.luceneProvider((FileSystemAbstraction)fs, (IndexDirectoryStructure.Factory)childDirectoryStructure, (Monitors)monitors, (String)monitorTag, (Config)config, (DatabaseReadOnlyChecker)readOnlyChecker);
        return new FusionIndexProvider(generic, (IndexProvider)lucene, new FusionSlotSelector30(), DESCRIPTOR, IndexDirectoryStructure.directoriesByProvider((Path)databaseDirectory), fs, archiveFailedIndex, readOnlyChecker);
    }

    @VisibleForTesting
    public static IndexDirectoryStructure.Factory subProviderDirectoryStructure(Path databaseDirectory) {
        return NativeLuceneFusionIndexProviderFactory30.subProviderDirectoryStructure(databaseDirectory, DESCRIPTOR);
    }

    @VisibleForTesting
    public static IndexDirectoryStructure.Factory subProviderDirectoryStructure(Path databaseDirectory, IndexProviderDescriptor descriptor) {
        IndexDirectoryStructure parentDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)databaseDirectory).forProvider(descriptor);
        return IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)parentDirectoryStructure);
    }
}

