/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;

public final class TokenIndexes {
    private TokenIndexes() {
    }

    public static InternalIndexState readState(PageCache pageCache, Path indexFile, String databaseName, CursorContext cursorContext) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(2);
        GBPTree.readHeader((PageCache)pageCache, (Path)indexFile, (Header.Reader)headerReader, (String)databaseName, (CursorContext)cursorContext);
        switch (headerReader.state) {
            case 2: {
                return InternalIndexState.FAILED;
            }
            case 0: {
                return InternalIndexState.ONLINE;
            }
            case 1: {
                return InternalIndexState.POPULATING;
            }
        }
        throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
    }

    static String readFailureMessage(PageCache pageCache, Path indexFile, String databaseName, CursorContext cursorContext) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(2);
        GBPTree.readHeader((PageCache)pageCache, (Path)indexFile, (Header.Reader)headerReader, (String)databaseName, (CursorContext)cursorContext);
        return headerReader.failureMessage;
    }
}

