/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.PullingProducerStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.lock.LockWaitStrategies;

public class ReadEntityIdsStep
extends PullingProducerStep {
    private static final String CURSOR_TRACER_TAG = "indexPopulationReadEntityIds";
    private final StoreScan.ExternalUpdatesCheck externalUpdatesCheck;
    private final AtomicBoolean continueScanning;
    private final Function<CursorContext, EntityIdIterator> entityIdIteratorSupplier;
    private final PageCacheTracer pageCacheTracer;
    private volatile long position;
    private CursorContext cursorContext;
    private EntityIdIterator entityIdIterator;
    private long lastEntityId;

    public ReadEntityIdsStep(StageControl control, Configuration configuration, Function<CursorContext, EntityIdIterator> entityIdIteratorSupplier, PageCacheTracer cacheTracer, StoreScan.ExternalUpdatesCheck externalUpdatesCheck, AtomicBoolean continueScanning) {
        super(control, configuration);
        this.entityIdIteratorSupplier = entityIdIteratorSupplier;
        this.pageCacheTracer = cacheTracer;
        this.externalUpdatesCheck = externalUpdatesCheck;
        this.continueScanning = continueScanning;
    }

    protected void process() {
        this.cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(CURSOR_TRACER_TAG));
        this.entityIdIterator = this.entityIdIteratorSupplier.apply(this.cursorContext);
        super.process();
    }

    protected Object nextBatchOrNull(long ticket, int batchSize) {
        if (!this.continueScanning.get() || !this.entityIdIterator.hasNext()) {
            return null;
        }
        this.checkAndApplyExternalUpdates();
        long[] entityIds = new long[batchSize];
        int cursor = 0;
        while (cursor < batchSize && this.entityIdIterator.hasNext()) {
            entityIds[cursor++] = this.entityIdIterator.next();
        }
        this.position += (long)cursor;
        this.lastEntityId = entityIds[cursor - 1];
        return cursor == entityIds.length ? entityIds : Arrays.copyOf(entityIds, cursor);
    }

    private void checkAndApplyExternalUpdates() {
        if (this.externalUpdatesCheck.needToApplyExternalUpdates()) {
            long i = 0L;
            while (!this.control.isIdle()) {
                LockWaitStrategies.INCREMENTAL_BACKOFF.apply(i);
                ++i;
            }
            this.externalUpdatesCheck.applyExternalUpdates(this.lastEntityId);
            this.entityIdIterator.invalidateCache();
        }
    }

    protected void done() {
        super.done();
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.entityIdIterator, this.cursorContext});
    }

    protected long position() {
        return this.position;
    }
}

