/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexedStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelIndexedNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipIndexedRelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;

public class DynamicIndexStoreView
implements IndexStoreView {
    private final FullScanStoreView fullScanStoreView;
    private final Locks locks;
    protected final LockService lockService;
    private final Config config;
    private final IndexingService.IndexProxyProvider indexProxies;
    protected final Supplier<StorageReader> storageReader;
    private final Log log;

    public DynamicIndexStoreView(FullScanStoreView fullScanStoreView, Locks locks, LockService lockService, Config config, IndexingService.IndexProxyProvider indexProxies, Supplier<StorageReader> storageReader, LogProvider logProvider) {
        this.fullScanStoreView = fullScanStoreView;
        this.locks = locks;
        this.lockService = lockService;
        this.config = config;
        this.indexProxies = indexProxies;
        this.storageReader = storageReader;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public StoreScan visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer labelScanConsumer, boolean forceStoreScan, boolean parallelWrite, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        Optional<TokenIndexData> tokenIndex = this.findTokenIndex(this.storageReader, EntityType.NODE);
        if (tokenIndex.isPresent()) {
            LabelIndexedNodeStoreScan nodeStoreScan = new LabelIndexedNodeStoreScan(this.config, this.storageReader.get(), this.lockService, tokenIndex.get().reader, labelScanConsumer, propertyScanConsumer, labelIds, propertyKeyIdFilter, parallelWrite, this.fullScanStoreView.scheduler, cacheTracer, memoryTracker);
            return new IndexedStoreScan(this.locks, tokenIndex.get().descriptor, this.config, nodeStoreScan);
        }
        return this.fullScanStoreView.visitNodes(labelIds, propertyKeyIdFilter, propertyScanConsumer, labelScanConsumer, forceStoreScan, parallelWrite, cacheTracer, memoryTracker);
    }

    @Override
    public StoreScan visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer relationshipTypeScanConsumer, boolean forceStoreScan, boolean parallelWrite, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        Optional<TokenIndexData> tokenIndex = this.findTokenIndex(this.storageReader, EntityType.RELATIONSHIP);
        if (tokenIndex.isPresent()) {
            RelationshipIndexedRelationshipStoreScan relationshipStoreScan = new RelationshipIndexedRelationshipStoreScan(this.config, this.storageReader.get(), this.lockService, tokenIndex.get().reader, relationshipTypeScanConsumer, propertyScanConsumer, relationshipTypeIds, propertyKeyIdFilter, parallelWrite, this.fullScanStoreView.scheduler, cacheTracer, memoryTracker);
            return new IndexedStoreScan(this.locks, tokenIndex.get().descriptor, this.config, relationshipStoreScan);
        }
        return this.fullScanStoreView.visitRelationships(relationshipTypeIds, propertyKeyIdFilter, propertyScanConsumer, relationshipTypeScanConsumer, forceStoreScan, parallelWrite, cacheTracer, memoryTracker);
    }

    @Override
    public boolean isEmpty() {
        return this.fullScanStoreView.isEmpty();
    }

    @Override
    public NodePropertyAccessor newPropertyAccessor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.fullScanStoreView.newPropertyAccessor(cursorContext, memoryTracker);
    }

    private Optional<TokenIndexData> findTokenIndex(Supplier<StorageReader> storageReader, EntityType entityType) {
        Iterator descriptorIterator = storageReader.get().indexGetForSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)entityType));
        if (!descriptorIterator.hasNext()) {
            return Optional.empty();
        }
        try {
            IndexProxy indexProxy = this.indexProxies.getIndexProxy((IndexDescriptor)descriptorIterator.next());
            if (indexProxy.getState() == InternalIndexState.ONLINE) {
                return Optional.of(new TokenIndexData(indexProxy.newTokenReader(), indexProxy.getDescriptor()));
            }
        }
        catch (IndexNotFoundKernelException e) {
            this.log.warn("Token index missing for entity: %s, switching to full scan", new Object[]{entityType, e});
        }
        return Optional.empty();
    }

    private static class TokenIndexData {
        private final TokenIndexReader reader;
        private final IndexDescriptor descriptor;

        private TokenIndexData(TokenIndexReader reader, IndexDescriptor descriptor) {
            this.reader = reader;
            this.descriptor = descriptor;
        }
    }
}

