/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeMinimalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TokenIndexPopulator;
import org.neo4j.kernel.impl.index.schema.TokenIndexes;
import org.neo4j.kernel.impl.index.schema.WorkSyncedIndexPopulator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.storageengine.migration.TokenIndexMigrator;
import org.neo4j.values.storable.ValueCategory;

public class TokenIndexProvider
extends IndexProvider {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("token-lookup", "1.0");
    public static final IndexCapability CAPABILITY = new TokenIndexCapability();
    private final DatabaseIndexContext databaseIndexContext;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final IndexProvider.Monitor monitor;
    private final Config config;
    private final DatabaseLayout databaseLayout;

    protected TokenIndexProvider(DatabaseIndexContext databaseIndexContext, IndexDirectoryStructure.Factory directoryStructureFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config, DatabaseLayout databaseLayout) {
        super(DESCRIPTOR, directoryStructureFactory);
        this.databaseIndexContext = databaseIndexContext;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.monitor = (IndexProvider.Monitor)databaseIndexContext.monitors.newMonitor(IndexProvider.Monitor.class, new String[]{databaseIndexContext.monitorTag});
        this.config = config;
        this.databaseLayout = databaseLayout;
    }

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor) {
        return new NativeMinimalIndexAccessor(descriptor, this.indexFiles(descriptor), this.databaseIndexContext.readOnlyChecker);
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
        if (this.databaseIndexContext.readOnlyChecker.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        return new WorkSyncedIndexPopulator(new TokenIndexPopulator(this.databaseIndexContext, this.databaseLayout, this.indexFiles(descriptor), this.config, descriptor));
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
        return new TokenIndexAccessor(this.databaseIndexContext, this.databaseLayout, this.indexFiles(descriptor), this.config, descriptor, this.recoveryCleanupWorkCollector);
    }

    public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext) {
        try {
            String failureMessage = TokenIndexes.readFailureMessage(this.databaseIndexContext.pageCache, this.storeFile(descriptor), this.databaseIndexContext.databaseName, cursorContext);
            return (String)StringUtils.defaultIfEmpty((CharSequence)failureMessage, (CharSequence)"");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext) {
        try {
            return TokenIndexes.readState(this.databaseIndexContext.pageCache, this.storeFile(descriptor), this.databaseIndexContext.databaseName, cursorContext);
        }
        catch (IOException | MetadataMismatchException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        return new TokenIndexMigrator("Token indexes", fs, storageEngineFactory, this.databaseLayout);
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        if (index.getCapability().equals(IndexCapability.NO_CAPABILITY)) {
            index = index.withIndexCapability(CAPABILITY);
        }
        return index;
    }

    public void validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        if (indexType != IndexType.LOOKUP) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support " + indexType + " indexes: " + prototype);
        }
        if (!prototype.schema().isAnyTokenSchemaDescriptor()) {
            throw new IllegalArgumentException("The " + prototype.schema() + " index schema is not an any-token index schema, which it is required to be for the '" + this.getProviderDescriptor().name() + "' index provider to be able to create an index.");
        }
        if (!prototype.getIndexProvider().equals((Object)DESCRIPTOR)) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support " + prototype.getIndexProvider() + " indexes: " + prototype);
        }
        if (prototype.isUnique()) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support uniqueness indexes: " + prototype);
        }
    }

    private Path storeFile(IndexDescriptor descriptor) {
        IndexFiles indexFiles = this.indexFiles(descriptor);
        return indexFiles.getStoreFile();
    }

    private IndexFiles indexFiles(IndexDescriptor descriptor) {
        EntityType entityType = descriptor.schema().entityType();
        boolean labelIndex = entityType == EntityType.NODE;
        Path filePath = labelIndex ? this.databaseLayout.labelScanStore() : this.databaseLayout.relationshipTypeScanStore();
        return new IndexFiles.SingleFile(this.databaseIndexContext.fileSystem, filePath);
    }

    private static class TokenIndexCapability
    implements IndexCapability {
        private TokenIndexCapability() {
        }

        public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
            return IndexOrderCapability.BOTH_FULLY_SORTED;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.YES;
        }

        public IndexBehaviour[] behaviours() {
            return new IndexBehaviour[0];
        }
    }
}

