/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;

class GenericLayout
extends IndexLayout<GenericKey, NativeIndexValue> {
    private final int numberOfSlots;
    private final IndexSpecificSpaceFillingCurveSettings spatialSettings;

    GenericLayout(int numberOfSlots, IndexSpecificSpaceFillingCurveSettings spatialSettings) {
        super(false, Layout.namedIdentifier((String)"NSIL", (int)numberOfSlots), 0, 5);
        this.numberOfSlots = numberOfSlots;
        this.spatialSettings = spatialSettings;
    }

    public GenericKey newKey() {
        return this.numberOfSlots == 1 ? new GenericKey(this.spatialSettings) : new CompositeGenericKey(this.numberOfSlots, this.spatialSettings);
    }

    public GenericKey copyKey(GenericKey key, GenericKey into) {
        into.copyFrom(key);
        return into;
    }

    public int keySize(GenericKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, GenericKey key) {
        key.put(cursor);
    }

    public void readKey(PageCursor cursor, GenericKey into, int keySize) {
        into.get(cursor, keySize);
    }

    public void minimalSplitter(GenericKey left, GenericKey right, GenericKey into) {
        right.minimalSplitter(left, right, into);
    }

    IndexSpecificSpaceFillingCurveSettings getSpaceFillingCurveSettings() {
        return this.spatialSettings;
    }

    public void initializeAsLowest(GenericKey key) {
        key.initValuesAsLowest();
    }

    public void initializeAsHighest(GenericKey key) {
        key.initValuesAsHighest();
    }
}

