/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import java.util.SortedMap;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.lifecycle.Lifecycle;

public interface DatabaseManager<DB extends DatabaseContext>
extends Lifecycle {
    default public void initialiseSystemDatabase() {
    }

    default public void initialiseDefaultDatabase() {
    }

    public Optional<DB> getDatabaseContext(NamedDatabaseId var1);

    default public Optional<DB> getDatabaseContext(String databaseName) {
        return this.databaseIdRepository().getByName(databaseName).flatMap(this::getDatabaseContext);
    }

    default public Optional<DB> getDatabaseContext(DatabaseId databaseId) {
        return this.databaseIdRepository().getById(databaseId).flatMap(this::getDatabaseContext);
    }

    public DB createDatabase(NamedDatabaseId var1) throws DatabaseManagementException;

    public void dropDatabase(NamedDatabaseId var1) throws DatabaseNotFoundException;

    default public void upgradeDatabase(NamedDatabaseId namedDatabaseId) throws DatabaseNotFoundException {
        throw new UnsupportedOperationException("Database upgrade is not yet implemented for " + this.getClass().getSimpleName());
    }

    public void stopDatabase(NamedDatabaseId var1) throws DatabaseNotFoundException;

    public void startDatabase(NamedDatabaseId var1) throws DatabaseNotFoundException;

    public SortedMap<NamedDatabaseId, DB> registeredDatabases();

    public DatabaseIdRepository.Caching databaseIdRepository();
}

