/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.monitoring.Monitors;

public class GenericNativeIndexProviderFactory
extends AbstractIndexProviderFactory {
    public GenericNativeIndexProviderFactory() {
        super(GenericNativeIndexProvider.KEY);
    }

    @Override
    protected Class<?> loggingClass() {
        return GenericNativeIndexProvider.class;
    }

    @Override
    public IndexProviderDescriptor descriptor() {
        return GenericNativeIndexProvider.DESCRIPTOR;
    }

    @Override
    protected GenericNativeIndexProvider internalCreate(PageCache pageCache, Path storeDir, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer) {
        return GenericNativeIndexProviderFactory.create(pageCache, storeDir, fs, monitors, monitorTag, config, readOnlyChecker, recoveryCleanupWorkCollector, pageCacheTracer, databaseLayout.getDatabaseName());
    }

    public static GenericNativeIndexProvider create(PageCache pageCache, Path storeDir, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer pageCacheTracer, String databaseName) {
        IndexDirectoryStructure.Factory directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)storeDir);
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder(pageCache, fs, databaseName).withMonitors(monitors).withTag(monitorTag).withReadOnlyChecker(readOnlyChecker).withPageCacheTracer(pageCacheTracer).build();
        return new GenericNativeIndexProvider(databaseIndexContext, directoryStructure, recoveryCleanupWorkCollector, config);
    }
}

