/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;

public class FilteringNodeCursorWrapper
implements NodeCursor {
    private final NodeCursor delegate;
    private final Predicate<NodeCursor> filter;
    private final Collection<AutoCloseable> resources;

    public FilteringNodeCursorWrapper(NodeCursor delegate, Predicate<NodeCursor> filter) {
        this(delegate, filter, Collections.emptyList());
    }

    public FilteringNodeCursorWrapper(NodeCursor delegate, Predicate<NodeCursor> filter, Collection<AutoCloseable> resources) {
        this.delegate = delegate;
        this.filter = filter;
        this.resources = resources;
    }

    public boolean next() {
        while (this.delegate.next()) {
            if (!this.filter.test(this.delegate)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        IOUtils.closeAllSilently(this.resources);
        this.delegate.close();
    }

    public void closeInternal() {
        this.delegate.closeInternal();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setCloseListener(CloseListener closeListener) {
        this.delegate.setCloseListener(closeListener);
    }

    public void setToken(int token) {
        this.delegate.setToken(token);
    }

    public int getToken() {
        return this.delegate.getToken();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.delegate.setTracer(tracer);
    }

    public void removeTracer() {
        this.delegate.removeTracer();
    }

    public long nodeReference() {
        return this.delegate.nodeReference();
    }

    public TokenSet labels() {
        return this.delegate.labels();
    }

    public TokenSet labelsIgnoringTxStateSetRemove() {
        return this.delegate.labelsIgnoringTxStateSetRemove();
    }

    public boolean hasLabel(int label) {
        return this.delegate.hasLabel(label);
    }

    public void relationships(RelationshipTraversalCursor relationships, RelationshipSelection selection) {
        this.delegate.relationships(relationships, selection);
    }

    public void properties(PropertyCursor cursor) {
        this.delegate.properties(cursor);
    }

    public long relationshipsReference() {
        return this.delegate.relationshipsReference();
    }

    public long propertiesReference() {
        return this.delegate.propertiesReference();
    }

    public boolean supportsFastDegreeLookup() {
        return this.delegate.supportsFastDegreeLookup();
    }

    public int[] relationshipTypes() {
        return this.delegate.relationshipTypes();
    }

    public Degrees degrees(RelationshipSelection selection) {
        return this.delegate.degrees(selection);
    }

    public int degree(RelationshipSelection selection) {
        return this.delegate.degree(selection);
    }

    public int degreeWithMax(int maxDegree, RelationshipSelection selection) {
        return this.delegate.degreeWithMax(maxDegree, selection);
    }
}

