/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.util.Set;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.lock.LockType;

class ExclusiveLock
implements ForsetiLockManager.Lock {
    private final ForsetiClient owner;
    private volatile boolean closed;

    ExclusiveLock(ForsetiClient owner) {
        this.owner = owner;
    }

    @Override
    public void copyHolderWaitListsInto(SimpleBitSet waitList) {
        this.owner.copyWaitListTo(waitList);
    }

    @Override
    public int detectDeadlock(int client) {
        return !this.closed && this.owner.isWaitingFor(client) ? this.owner.id() : -1;
    }

    @Override
    public String describeWaitList() {
        return "ExclusiveLock[" + this.owner.describeWaitList() + "]";
    }

    @Override
    public void collectOwners(Set<ForsetiClient> owners) {
        owners.add(this.owner);
    }

    @Override
    public boolean isOwnedBy(ForsetiClient client) {
        return this.owner.equals(client);
    }

    @Override
    public LockType type() {
        return LockType.EXCLUSIVE;
    }

    @Override
    public LongSet transactionIds() {
        return LongSets.immutable.of(this.owner.transactionId());
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "ExclusiveLock{owner=" + this.owner + "}";
    }

    void close() {
        this.closed = true;
    }
}

