/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class ZonedDateTimeType
extends Type {
    private static final int ZONE_ID_FLAG = 0x1000000;
    private static final int ZONE_ID_MASK = 0xFFFFFF;
    private static final int ZONE_ID_HIGH = 0x800000;
    private static final int ZONE_ID_EXT = -16777216;

    ZonedDateTimeType(byte typeId) {
        super(ValueGroup.ZONED_DATE_TIME, typeId, (Value)DateTimeValue.MIN_VALUE, (Value)DateTimeValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey state) {
        return 16;
    }

    @Override
    void copyValue(GenericKey to, GenericKey from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        to.long3 = from.long3;
    }

    @Override
    Value asValue(GenericKey state) {
        return ZonedDateTimeType.asValue(state.long0, state.long1, state.long2, state.long3);
    }

    @Override
    int compareValue(GenericKey left, GenericKey right) {
        return ZonedDateTimeType.compare(left.long0, left.long1, left.long2, left.long3, right.long0, right.long1, right.long2, right.long3);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        ZonedDateTimeType.put(cursor, state.long0, state.long1, state.long2, state.long3);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey into) {
        return ZonedDateTimeType.read(cursor, into);
    }

    static int compare(long this_long0, long this_long1, long this_long2, long this_long3, long that_long0, long that_long1, long that_long2, long that_long3) {
        int compare = Long.compare(this_long0, that_long0);
        if (compare == 0 && (compare = Integer.compare((int)this_long1, (int)that_long1)) == 0 && (this_long2 != that_long2 || this_long3 != that_long3) && TimeZones.validZoneOffset((int)((int)this_long3)) && TimeZones.validZoneOffset((int)((int)that_long3))) {
            compare = Values.COMPARATOR.compare((Value)ZonedDateTimeType.asValue(this_long0, this_long1, this_long2, this_long3), (Value)ZonedDateTimeType.asValue(that_long0, that_long1, that_long2, that_long3));
        }
        return compare;
    }

    static void put(PageCursor cursor, long long0, long long1, long long2, long long3) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
        if (long2 >= 0L) {
            cursor.putInt((int)long2 | 0x1000000);
        } else {
            cursor.putInt((int)long3 & 0xFFFFFF);
        }
    }

    static boolean read(PageCursor cursor, GenericKey into) {
        long epochSecondUTC = cursor.getLong();
        int nanoOfSecond = cursor.getInt();
        int encodedZone = cursor.getInt();
        if (ZonedDateTimeType.isZoneId(encodedZone)) {
            into.writeDateTime(epochSecondUTC, nanoOfSecond, ZonedDateTimeType.asZoneId(encodedZone));
        } else {
            into.writeDateTime(epochSecondUTC, nanoOfSecond, ZonedDateTimeType.asZoneOffset(encodedZone));
        }
        return true;
    }

    static DateTimeValue asValue(long long0, long long1, long long2, long long3) {
        return DateTimeValue.datetime((ZonedDateTime)ZonedDateTimeType.asValueRaw(long0, long1, long2, long3));
    }

    static ZonedDateTime asValueRaw(long long0, long long1, long long2, long long3) {
        return TimeZones.validZoneId((short)((short)long2)) ? DateTimeValue.datetimeRaw((long)long0, (long)long1, (ZoneId)ZoneId.of(TimeZones.map((short)((short)long2)))) : DateTimeValue.datetimeRaw((long)long0, (long)long1, (ZoneOffset)ZoneOffset.ofTotalSeconds((int)long3));
    }

    static void write(GenericKey state, long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        state.long0 = epochSecondUTC;
        state.long1 = nano;
        state.long2 = zoneId;
        state.long3 = offsetSeconds;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long3=" + state.long3);
    }

    private static int asZoneOffset(int encodedZone) {
        if ((0x800000 & encodedZone) == 0x800000) {
            return 0xFF000000 | encodedZone;
        }
        return encodedZone;
    }

    private static short asZoneId(int encodedZone) {
        return (short)(encodedZone & 0xFFFFFF);
    }

    private static boolean isZoneId(int encodedZone) {
        return (encodedZone & 0x1000000) != 0;
    }
}

