/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public abstract class IndexFiles {
    public abstract Path getStoreFile();

    public abstract Path getBase();

    public abstract void clear();

    public abstract void archiveIndex() throws IOException;

    public abstract void ensureDirectoryExist();

    public String toString() {
        return String.format("%s[base=%s,storeFile=%s]", this.getClass().getSimpleName(), this.getBase(), this.getStoreFile());
    }

    public static class SingleFile
    extends IndexFiles {
        private final FileSystemAbstraction fs;
        private final Path singleFile;

        public SingleFile(FileSystemAbstraction fs, Path singleFile) {
            this.fs = fs;
            this.singleFile = singleFile;
        }

        @Override
        public Path getStoreFile() {
            return this.singleFile;
        }

        @Override
        public Path getBase() {
            return this.singleFile;
        }

        @Override
        public void clear() {
            try {
                if (this.fs.fileExists(this.singleFile)) {
                    this.fs.deleteFileOrThrow(this.singleFile);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void archiveIndex() {
            if (this.fs.fileExists(this.singleFile)) {
                try {
                    ZipUtils.zip((FileSystemAbstraction)this.fs, (Path)this.singleFile, (Path)this.singleFile.resolve("archive-" + this.singleFile.getFileName() + "-" + System.currentTimeMillis() + ".zip"));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        @Override
        public void ensureDirectoryExist() {
        }
    }

    public static class Directory
    extends IndexFiles {
        private final FileSystemAbstraction fs;
        private final Path directory;
        private final Path storeFile;

        public Directory(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure, long indexId) {
            this.fs = fs;
            this.directory = directoryStructure.directoryForIndex(indexId);
            this.storeFile = this.directory.resolve(Directory.indexFileName(indexId));
        }

        @Override
        public Path getStoreFile() {
            return this.storeFile;
        }

        @Override
        public Path getBase() {
            return this.directory;
        }

        @Override
        public void clear() {
            try {
                if (this.fs.fileExists(this.directory)) {
                    this.fs.deleteRecursively(this.directory);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void archiveIndex() throws IOException {
            if (this.fs.isDirectory(this.directory) && this.fs.fileExists(this.directory) && this.fs.listFiles(this.directory).length > 0) {
                ZipUtils.zip((FileSystemAbstraction)this.fs, (Path)this.directory, (Path)this.directory.getParent().resolve("archive-" + this.directory.getFileName() + "-" + System.currentTimeMillis() + ".zip"));
            }
        }

        @Override
        public void ensureDirectoryExist() {
            try {
                this.fs.mkdirs(this.directory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static String indexFileName(long indexId) {
            return "index-" + indexId;
        }
    }
}

